/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.mixin;

import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworldapoth.config.OWApothConfig;
import dev.muon.otherworldapoth.loot.LootUtils;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RandomizableContainerBlockEntity.class})
public abstract class RandomizableContainerBlockEntityMixin {
    @Inject(method={"unpackLootTable"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;fill(Lnet/minecraft/world/Container;Lnet/minecraft/world/level/storage/loot/LootParams;J)V", shift=At.Shift.AFTER)})
    private void otherworldapoth$modifyChestLoot(@Nullable Player player, CallbackInfo ci) {
        if (player == null) {
            return;
        }
        RandomizableContainerBlockEntity self = (RandomizableContainerBlockEntity)this;
        int level = LevelingUtils.getPlayerLevel((Player)player);
        if (level < 1) {
            return;
        }
        float conversionChance = (float)Math.min(OWApothConfig.chestLootBaseChance + (double)level * OWApothConfig.chestLootLevelChanceIncrease, OWApothConfig.chestLootMaxChance);
        for (int i = 0; i < self.m_6643_(); ++i) {
            ItemStack stack = self.m_8020_(i);
            if (LootCategory.forItem((ItemStack)stack).isNone() || !AffixHelper.getAffixes((ItemStack)stack).isEmpty() || !(player.m_217043_().m_188501_() < conversionChance)) continue;
            LootRarity rarity = LootUtils.getRarityForPlayerLevel(level, player.m_217043_(), player.m_36336_());
            LootController.createLootItem((ItemStack)stack, (LootRarity)rarity, (RandomSource)player.m_217043_());
        }
    }
}

