/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.loot;

import dev.muon.otherworldapoth.OtherworldApoth;
import dev.muon.otherworldapoth.config.OWApothConfig;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootUtils {
    public static String findMappingForLevel(String[] mappings, int level) {
        return Arrays.stream(mappings).map(s -> s.split("=")).filter(parts -> Integer.parseInt(parts[0]) <= level).max((a, b) -> Integer.compare(Integer.parseInt(a[0]), Integer.parseInt(b[0]))).map(parts -> parts[1]).orElse("common-common");
    }

    @Nullable
    public static Player findRelevantPlayer(LootContext ctx) {
        Object object = ctx.m_78953_(LootContextParams.f_81455_);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        object = ctx.m_78953_(LootContextParams.f_81459_);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        object = ctx.m_78953_(LootContextParams.f_81458_);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        if (ctx.m_78953_(LootContextParams.f_81456_) != null) {
            return (Player)ctx.m_78953_(LootContextParams.f_81456_);
        }
        return null;
    }

    public static LootRarity getRarityForPlayerLevel(int playerLevel, RandomSource rand, float luck) {
        String mapping = LootUtils.findMappingForLevel(OWApothConfig.playerLevelRarityMappings, playerLevel);
        OtherworldApoth.LOGGER.debug("Finding rarity for player level {}, mapping: {}", (Object)playerLevel, (Object)mapping);
        String[] rarities = mapping.split("-");
        DynamicHolder minRarity = RarityRegistry.INSTANCE.holder(Apotheosis.loc((String)rarities[0]));
        DynamicHolder maxRarity = RarityRegistry.INSTANCE.holder(Apotheosis.loc((String)rarities[1]));
        List<DynamicHolder> validRarities = RarityRegistry.INSTANCE.getOrderedRarities().stream().filter(r -> ((LootRarity)r.get()).ordinal() >= ((LootRarity)minRarity.get()).ordinal() && ((LootRarity)r.get()).ordinal() <= ((LootRarity)maxRarity.get()).ordinal()).toList();
        double totalWeight = validRarities.stream().mapToDouble(r -> {
            LootRarity rarity = (LootRarity)r.get();
            return (float)rarity.getWeight() + luck * rarity.getQuality();
        }).sum();
        double roll = rand.m_188500_() * totalWeight;
        double currentWeight = 0.0;
        DynamicHolder selected = validRarities.get(0);
        for (DynamicHolder rarity : validRarities) {
            LootRarity r2 = (LootRarity)rarity.get();
            if (!(roll <= (currentWeight += (double)((float)r2.getWeight() + luck * r2.getQuality())))) continue;
            selected = rarity;
            break;
        }
        OtherworldApoth.LOGGER.debug("Selected rarity: {}", (Object)selected.getId());
        return (LootRarity)selected.get();
    }

    public static LootRarity getRarityForMobLevel(int mobLevel, RandomSource rand, float luck, boolean isGem) {
        String mapping = LootUtils.findMappingForLevel(isGem ? OWApothConfig.gemRarityMappings : OWApothConfig.levelRarityMappings, mobLevel);
        OtherworldApoth.LOGGER.debug("Finding rarity for mob level {} ({}), mapping: {}", (Object)mobLevel, (Object)(isGem ? "gem" : "item"), (Object)mapping);
        String[] rarities = mapping.split("-");
        DynamicHolder minRarity = RarityRegistry.INSTANCE.holder(Apotheosis.loc((String)rarities[0]));
        DynamicHolder maxRarity = RarityRegistry.INSTANCE.holder(Apotheosis.loc((String)rarities[1]));
        List<DynamicHolder> validRarities = RarityRegistry.INSTANCE.getOrderedRarities().stream().filter(r -> ((LootRarity)r.get()).ordinal() >= ((LootRarity)minRarity.get()).ordinal() && ((LootRarity)r.get()).ordinal() <= ((LootRarity)maxRarity.get()).ordinal()).toList();
        double luckBonus = Math.max(0.0, (double)luck * 0.1);
        double totalWeight = validRarities.stream().mapToDouble(r -> {
            LootRarity rarity = (LootRarity)r.get();
            return (float)rarity.getWeight() + luck * rarity.getQuality();
        }).sum();
        double roll = rand.m_188500_() * totalWeight;
        double currentWeight = 0.0;
        DynamicHolder selected = validRarities.get(0);
        for (DynamicHolder rarity : validRarities) {
            if (!(roll <= (currentWeight += (double)((LootRarity)rarity.get()).getWeight() + luckBonus))) continue;
            selected = rarity;
            break;
        }
        OtherworldApoth.LOGGER.debug("Selected rarity: {}", (Object)selected.getId());
        return (LootRarity)selected.get();
    }
}

