/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.loot;

import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworldapoth.OtherworldApoth;
import dev.muon.otherworldapoth.config.OWApothConfig;
import dev.muon.otherworldapoth.loot.LootUtils;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LootEvents {
    public static final String PLAYER_DROPPED = "otherworldapoth.player_dropped";

    @SubscribeEvent
    public void onItemDrop(ItemTossEvent event) {
        ItemStack stack = event.getEntity().m_32055_();
        if (!LootCategory.forItem((ItemStack)stack).isNone()) {
            stack.m_41784_().m_128379_(PLAYER_DROPPED, true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Monster)) {
            return;
        }
        Monster monster = (Monster)livingEntity;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int level = LevelingUtils.getEntityLevel((LivingEntity)monster);
        if (level <= 0) {
            return;
        }
        OtherworldApoth.LOGGER.debug("Processing drops for level {} {}", (Object)level, (Object)monster.m_6095_().m_20676_());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack equipped = monster.m_6844_(slot);
            if (equipped.m_41619_()) continue;
            event.getDrops().forEach(drop -> {
                ItemStack stack = drop.m_32055_();
                if (stack.m_41720_() == equipped.m_41720_() && !LootCategory.forItem((ItemStack)stack).isNone() && AffixHelper.getAffixes((ItemStack)stack).isEmpty()) {
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null) {
                        return;
                    }
                    if (tag.m_128471_(PLAYER_DROPPED)) {
                        float chance = (float)Math.min(OWApothConfig.affixBaseChance + (double)level * OWApothConfig.affixLevelChanceIncrease, OWApothConfig.affixMaxChance);
                        float roll = monster.m_217043_().m_188501_();
                        if (roll < chance) {
                            LootRarity rarity = LootUtils.getRarityForMobLevel(level, monster.m_217043_(), player.m_36336_(), false);
                            LootController.createLootItem((ItemStack)stack, (LootRarity)rarity, (RandomSource)monster.m_217043_());
                        }
                    }
                }
            });
        }
    }
}

