/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworldapoth.config.OWApothConfig;
import dev.muon.otherworldapoth.loot.LootUtils;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class LeveledGemLootModifier
extends LootModifier {
    public static final Codec<LeveledGemLootModifier> CODEC = RecordCodecBuilder.create(inst -> LeveledGemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, LeveledGemLootModifier::new));

    protected LeveledGemLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof LivingEntity)) {
            return generatedLoot;
        }
        LivingEntity living = (LivingEntity)entity;
        int level = LevelingUtils.getEntityLevel((LivingEntity)living);
        if (level <= 0) {
            return generatedLoot;
        }
        if (this.shouldDropGem(level, context.m_230907_())) {
            LootRarity rarity = LootUtils.getRarityForMobLevel(level, context.m_230907_(), context.m_78945_(), true);
            Gem gem = (Gem)GemRegistry.INSTANCE.getRandomItem(context.m_230907_(), context.m_78945_(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)context.m_78952_())});
            if (gem != null) {
                ItemStack gemStack = GemRegistry.createGemStack((Gem)gem, (LootRarity)rarity);
                generatedLoot.add((Object)gemStack);
            }
        }
        return generatedLoot;
    }

    private boolean shouldDropGem(int level, RandomSource rand) {
        return (double)rand.m_188501_() < Math.min(OWApothConfig.gemBaseChance + (double)level * OWApothConfig.gemLevelChanceIncrease, OWApothConfig.gemMaxChance);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

