/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworldapoth.config.OWApothConfig;
import dev.muon.otherworldapoth.loot.LootUtils;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class LeveledAffixLootModifier
extends LootModifier {
    public static final Codec<LeveledAffixLootModifier> CODEC = RecordCodecBuilder.create(inst -> LeveledAffixLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, LeveledAffixLootModifier::new));

    protected LeveledAffixLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof LivingEntity)) {
            return generatedLoot;
        }
        LivingEntity living = (LivingEntity)entity;
        int level = LevelingUtils.getEntityLevel((LivingEntity)living);
        if (level <= 0) {
            return generatedLoot;
        }
        for (ItemStack stack : generatedLoot) {
            if (LootCategory.forItem((ItemStack)stack).isNone() || !AffixHelper.getAffixes((ItemStack)stack).isEmpty() || !this.shouldConvertItem(level, context.m_230907_())) continue;
            LootRarity rarity = LootUtils.getRarityForMobLevel(level, context.m_230907_(), context.m_78945_(), false);
            LootController.createLootItem((ItemStack)stack, (LootRarity)rarity, (RandomSource)context.m_230907_());
        }
        return generatedLoot;
    }

    private boolean shouldConvertItem(int level, RandomSource rand) {
        return (double)rand.m_188501_() < Math.min(OWApothConfig.affixBaseChance + (double)level * OWApothConfig.affixLevelChanceIncrease, OWApothConfig.affixMaxChance);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

