/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.config;

import dev.muon.otherworldapoth.OtherworldApoth;
import dev.shadowsoffire.placebo.config.Configuration;

public class OWApothConfig {
    private static Configuration config;
    public static double affixBaseChance;
    public static double affixLevelChanceIncrease;
    public static double affixMaxChance;
    public static double gemBaseChance;
    public static double gemLevelChanceIncrease;
    public static double gemMaxChance;
    public static double chestLootBaseChance;
    public static double chestLootLevelChanceIncrease;
    public static double chestLootMaxChance;
    public static String[] levelRarityMappings;
    public static String[] gemRarityMappings;
    public static String[] playerLevelRarityMappings;

    public static void init() {
        config = new Configuration("otherworldapoth");
        config.setTitle("Otherworld Apotheosis Configuration");
        String category = "loot";
        affixBaseChance = config.getFloat("affixBaseChance", category, 0.05f, 0.0f, 1.0f, "Base chance for an item to receive affixes");
        affixLevelChanceIncrease = config.getFloat("affixLevelChanceIncrease", category, 0.01f, 0.0f, 1.0f, "How much the affix chance increases per level");
        affixMaxChance = config.getFloat("affixMaxChance", category, 0.25f, 0.0f, 1.0f, "Maximum chance for an item to receive affixes");
        gemBaseChance = config.getFloat("gemBaseChance", category, 0.02f, 0.0f, 1.0f, "Base chance for a gem to drop");
        gemLevelChanceIncrease = config.getFloat("gemLevelChanceIncrease", category, 0.005f, 0.0f, 1.0f, "How much the gem drop chance increases per level");
        gemMaxChance = config.getFloat("gemMaxChance", category, 0.15f, 0.0f, 1.0f, "Maximum chance for a gem to drop");
        chestLootBaseChance = config.getFloat("chestLootBaseChance", category, 0.15f, 0.0f, 1.0f, "Base chance for a chest item to receive affixes");
        chestLootLevelChanceIncrease = config.getFloat("chestLootLevelChanceIncrease", category, 0.02f, 0.0f, 1.0f, "How much the chest loot affix chance increases per player level");
        chestLootMaxChance = config.getFloat("chestLootMaxChance", category, 0.5f, 0.0f, 1.0f, "Maximum chance for a chest item to receive affixes");
        levelRarityMappings = config.getStringList("levelAffixMappings", category, new String[]{"25=mythic-ancient", "20=epic-mythic", "15=rare-epic", "10=uncommon-rare", "5=common-uncommon", "1=common-common"}, "Level threshold to rarity mapping for affixes. Format: 'level=minRarity-maxRarity'\nEach entry applies to levels from its value up to (but not including) the next threshold.\nFor example: '20=epic-mythic' applies to levels 20-24 if the next threshold is 25.\nValid rarities: common, uncommon, rare, epic, mythic, ancientNote that within a given range, which rarity gets assigned is still determined by theweights defined in the rarity itself, and is affected by Luck.");
        gemRarityMappings = config.getStringList("levelGemMappings", category, new String[]{"25=mythic-ancient", "20=epic-mythic", "15=rare-epic", "10=uncommon-rare", "5=common-uncommon", "1=common-common"}, "Level:Rarity mapping for gems. Format: 'level=minRarity-maxRarity'\nEach entry applies to levels from its value up to (but not including) the next threshold.\nFor example: '20=epic-mythic' applies to levels 20-24 if the next threshold is 25.\nValid rarities: common, uncommon, rare, epic, mythic, ancientNote that within a given range, which rarity gets assigned is still determined by theweights defined in the rarity itself, and is affected by Luck.");
        playerLevelRarityMappings = config.getStringList("playerLevelMappings", category, new String[]{"16=rare-mythic", "12=rare-epic", "6=uncommon-rare", "4=common-uncommon", "2=common-common"}, "Level threshold to rarity mapping for container loot based on player level.\nEach entry applies to levels from its value up to (but not including) the next threshold.\nFor example: '15=rare-epic' applies to levels 15-19 if the next threshold is 20.\nValid rarities: common, uncommon, rare, epic, mythic, ancient");
        OtherworldApoth.LOGGER.info("OtherworldApoth Config loaded:");
        OtherworldApoth.LOGGER.info("Base chance: " + affixBaseChance);
        OtherworldApoth.LOGGER.info("Level increase: " + affixLevelChanceIncrease);
        OtherworldApoth.LOGGER.info("Max chance: " + affixMaxChance);
        OtherworldApoth.LOGGER.info("Rarity mappings: " + String.join((CharSequence)", ", levelRarityMappings));
        if (config.hasChanged()) {
            config.save();
        }
    }
}

