/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworldapoth.util.SpellCastUtil;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.IForgeRegistry;

public class SpellTriggerAffix
extends Affix {
    private static final ThreadLocal<Boolean> IS_TRIGGERING = ThreadLocal.withInitial(() -> false);
    public static final Codec<SpellTriggerAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)((IForgeRegistry)SpellRegistry.REGISTRY.get()).getCodec().fieldOf("spell").forGetter(a -> a.spell), (App)TriggerType.CODEC.fieldOf("trigger").forGetter(a -> a.trigger), (App)LootRarity.mapCodec(TriggerData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)TargetType.CODEC.optionalFieldOf("target").forGetter(a -> a.target)).apply((Applicative)inst, SpellTriggerAffix::new));
    protected final AbstractSpell spell;
    protected final TriggerType trigger;
    protected final Map<LootRarity, TriggerData> values;
    protected final Set<LootCategory> types;
    protected final Optional<TargetType> target;

    public static boolean isCurrentlyTriggering() {
        return IS_TRIGGERING.get();
    }

    public SpellTriggerAffix(AbstractSpell spell, TriggerType trigger, Map<LootRarity, TriggerData> values, Set<LootCategory> types, Optional<TargetType> target) {
        super(AffixType.ABILITY);
        this.spell = spell;
        this.trigger = trigger;
        this.values = values;
        this.types = types;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSpell(LivingEntity caster, LivingEntity target, LootRarity rarity, float level) {
        if (IS_TRIGGERING.get().booleanValue()) {
            return;
        }
        TriggerData data = this.values.get(rarity);
        if (data == null || caster.m_9236_().m_5776_()) {
            return;
        }
        int spellLevel = data.level().getInt(level);
        AbstractSpell spellInstance = this.spell;
        String spellId = spellInstance.getSpellId();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        boolean hasActiveRecast = magicData.getPlayerRecasts().hasRecastForSpell(spellId);
        int cooldown = data.cooldown();
        if (!hasActiveRecast && cooldown != 0 && Affix.isOnCooldown((ResourceLocation)this.getId(), (int)cooldown, (LivingEntity)caster)) {
            return;
        }
        try {
            IS_TRIGGERING.set(true);
            SpellCastUtil.castSpell(caster, spellInstance, spellLevel, target);
            if (!hasActiveRecast && cooldown != 0) {
                Affix.startCooldown((ResourceLocation)this.getId(), (LivingEntity)caster);
            }
        }
        finally {
            IS_TRIGGERING.set(false);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        TriggerData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        String triggerKey = "affix.otherworldapoth.trigger." + this.trigger.name().toLowerCase();
        AbstractSpell spellInstance = this.spell;
        int spellLevel = data.level().getInt(level);
        MutableComponent coloredSpellName = spellInstance.getDisplayName(null).m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + spellLevel))).m_130948_(spellInstance.getSchoolType().getDisplayName().m_7383_());
        boolean isSelfCast = this.target.map(t -> t == TargetType.SELF).orElse(false);
        String finalKey = isSelfCast ? triggerKey + ".self" : triggerKey;
        MutableComponent comp = Component.m_237110_((String)finalKey, (Object[])new Object[]{coloredSpellName});
        int cooldown = data.cooldown();
        if (cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        return comp;
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        int cooldown;
        int maxLevel;
        TriggerData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int currentLevel = data.level().getInt(level);
        AbstractSpell spellInstance = this.spell;
        MutableComponent coloredSpellName = spellInstance.getDisplayName(null).m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + currentLevel))).m_130948_(spellInstance.getSchoolType().getDisplayName().m_7383_());
        boolean isSelfCast = this.target.map(t -> t == TargetType.SELF).orElse(false);
        String triggerKey = "affix.otherworldapoth.trigger." + this.trigger.name().toLowerCase();
        String finalKey = isSelfCast ? triggerKey + ".self" : triggerKey;
        MutableComponent comp = Component.m_237110_((String)finalKey, (Object[])new Object[]{coloredSpellName});
        int minLevel = data.level().getInt(0.0f);
        if (minLevel != (maxLevel = data.level().getInt(1.0f))) {
            MutableComponent minComp = Component.m_237115_((String)("enchantment.level." + minLevel));
            MutableComponent maxComp = Component.m_237115_((String)("enchantment.level." + maxLevel));
            comp.m_7220_((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((cooldown = data.cooldown()) != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        return comp;
    }

    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, @Nullable Entity target) {
        if (this.trigger == TriggerType.MELEE_HIT && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            LivingEntity actualTarget = this.target.map(targetType -> switch (targetType) {
                default -> throw new IncompatibleClassChangeError();
                case TargetType.SELF -> user;
                case TargetType.TARGET -> livingTarget;
            }).orElse(livingTarget);
            this.triggerSpell(user, actualTarget, rarity, level);
        }
    }

    public void doPostHurt(ItemStack stack, LootRarity rarity, float level, LivingEntity user, @Nullable Entity attacker) {
        if (this.trigger == TriggerType.HURT && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            LivingEntity actualTarget = this.target.map(targetType -> switch (targetType) {
                default -> throw new IncompatibleClassChangeError();
                case TargetType.SELF -> user;
                case TargetType.TARGET -> livingAttacker;
            }).orElse(user);
            this.triggerSpell(user, actualTarget, rarity, level);
        }
    }

    public void onArrowImpact(AbstractArrow arrow, LootRarity rarity, float level, HitResult res, HitResult.Type type) {
        EntityHitResult entityHit;
        Entity entity;
        if (this.trigger == TriggerType.ARROW_HIT && type == HitResult.Type.ENTITY && res instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            entity = arrow.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                LivingEntity actualTarget = this.target.map(targetType -> switch (targetType) {
                    default -> throw new IncompatibleClassChangeError();
                    case TargetType.SELF -> owner;
                    case TargetType.TARGET -> hitEntity;
                }).orElse(hitEntity);
                this.triggerSpell(owner, actualTarget, rarity, level);
            }
        }
    }

    public static enum TriggerType {
        SPELL_DAMAGE,
        SPELL_HEAL,
        MELEE_HIT,
        ARROW_HIT,
        HURT;

        public static final Codec<TriggerType> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(TriggerType.class);
        }
    }

    public record TriggerData(StepFunction level, int cooldown) {
        private static final Codec<TriggerData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.optionalFieldOf("level", (Object)StepFunction.constant((float)1.0f)).forGetter(TriggerData::level), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(TriggerData::cooldown)).apply((Applicative)inst, TriggerData::new));
    }

    public static enum TargetType {
        SELF,
        TARGET;

        public static final Codec<TargetType> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(TargetType.class);
        }
    }
}

