/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworldapoth.util.SchoolUtil;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SpellLevelAffix
extends Affix {
    public static final Codec<SpellLevelAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("school").forGetter(a -> a.school.getId()), (App)LootRarity.mapCodec(LevelData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, SpellLevelAffix::new));
    protected final SchoolType school;
    protected final Map<LootRarity, LevelData> values;
    protected final Set<LootCategory> types;

    public SpellLevelAffix(ResourceLocation schoolId, Map<LootRarity, LevelData> values, Set<LootCategory> types) {
        super(AffixType.POTION);
        this.school = SchoolRegistry.getSchool((ResourceLocation)schoolId);
        if (this.school == null) {
            throw new IllegalArgumentException("Invalid school ID provided for SpellLevelAffix: " + String.valueOf(schoolId));
        }
        this.values = values;
        this.types = types;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        LevelData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int bonus = data.level().getInt(level);
        String schoolTranslationKey = "school." + this.school.getId().m_135827_() + "." + this.school.getId().m_135815_();
        return Component.m_237110_((String)"affix.otherworldapoth.spell_level.desc", (Object[])new Object[]{Component.m_237115_((String)schoolTranslationKey).m_130948_(this.school.getDisplayName().m_7383_()), bonus});
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        LevelData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int currentBonus = data.level().getInt(level);
        int minBonus = data.level().getInt(0.0f);
        int maxBonus = data.level().getInt(1.0f);
        String schoolTranslationKey = "school." + this.school.getId().m_135827_() + "." + this.school.getId().m_135815_();
        MutableComponent comp = Component.m_237110_((String)"affix.otherworldapoth.spell_level.desc", (Object[])new Object[]{Component.m_237115_((String)schoolTranslationKey).m_130948_(this.school.getDisplayName().m_7383_()), currentBonus});
        if (minBonus != maxBonus) {
            MutableComponent minComp = Component.m_237113_((String)String.valueOf(minBonus));
            MutableComponent maxComp = Component.m_237113_((String)String.valueOf(maxBonus));
            comp.m_7220_((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    public SchoolType getSchool() {
        return this.school;
    }

    public int getBonusLevel(LootRarity rarity, float level) {
        LevelData data = this.values.get(rarity);
        return data != null ? data.level().getInt(level) : 0;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat == null || cat.isNone()) {
            return false;
        }
        if (!this.types.isEmpty() && !this.types.contains(cat)) {
            return false;
        }
        Set<SchoolType> gearSchools = SchoolUtil.getSpellSchoolsFromGear(stack);
        return gearSchools.contains(this.school);
    }

    public record LevelData(StepFunction level) {
        private static final Codec<LevelData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.optionalFieldOf("level", (Object)StepFunction.constant((float)1.0f)).forGetter(LevelData::level)).apply((Applicative)inst, LevelData::new));
    }
}

