/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SocketBonusAffix
extends Affix {
    public static final Codec<SocketBonusAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(SocketData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, SocketBonusAffix::new));
    protected final Map<LootRarity, SocketData> values;
    protected final Set<LootCategory> types;

    public SocketBonusAffix(Map<LootRarity, SocketData> values, Set<LootCategory> types) {
        super(AffixType.POTION);
        this.values = values;
        this.types = types;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        SocketData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int bonus = data.level().getInt(level);
        if (bonus >= 1) {
            return Component.m_237110_((String)"affix.otherworldapoth.socket_bonus.desc_multiple", (Object[])new Object[]{bonus});
        }
        return Component.m_237110_((String)"affix.otherworldapoth.socket_bonus.desc", (Object[])new Object[]{bonus});
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        SocketData data = this.values.get(rarity);
        if (data == null) {
            return Component.m_237119_();
        }
        int currentBonus = data.level().getInt(level);
        int minBonus = data.level().getInt(0.0f);
        int maxBonus = data.level().getInt(1.0f);
        MutableComponent comp = Component.m_237110_((String)"affix.otherworldapoth.socket_bonus.desc", (Object[])new Object[]{currentBonus});
        if (minBonus != maxBonus) {
            MutableComponent minComp = Component.m_237113_((String)String.valueOf(minBonus));
            MutableComponent maxComp = Component.m_237113_((String)String.valueOf(maxBonus));
            comp.m_7220_((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    public int getBonusSockets(LootRarity rarity, float level) {
        SocketData data = this.values.get(rarity);
        return data != null ? data.level().getInt(level) : 0;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat == null || cat.isNone()) {
            return false;
        }
        return this.types.isEmpty() || this.types.contains(cat);
    }

    public record SocketData(StepFunction level) {
        private static final Codec<SocketData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.optionalFieldOf("sockets", (Object)StepFunction.constant((float)1.0f)).forGetter(SocketData::level)).apply((Applicative)inst, SocketData::new));
    }
}

