/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworldapoth.LootCategories;
import dev.muon.otherworldapoth.util.SchoolUtil;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ManaCostAffix
extends Affix {
    public static final Codec<ManaCostAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("school").forGetter(a -> a.school.getId()), (App)LootRarity.mapCodec((Codec)StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, ManaCostAffix::new));
    protected final SchoolType school;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;

    public ManaCostAffix(ResourceLocation schoolId, Map<LootRarity, StepFunction> values, Set<LootCategory> types) {
        super(AffixType.POTION);
        this.school = SchoolRegistry.getSchool((ResourceLocation)schoolId);
        if (this.school == null) {
            throw new IllegalArgumentException("Invalid school ID provided for ManaCostAffix: " + String.valueOf(schoolId));
        }
        this.values = values;
        this.types = types;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat != LootCategories.STAFF && cat != LootCategory.SWORD && cat != LootCategory.HEAVY_WEAPON) {
            return false;
        }
        if (!this.values.containsKey(rarity)) {
            return false;
        }
        if (!this.types.isEmpty() && !this.types.contains(cat)) {
            return false;
        }
        Set<SchoolType> gearSchools = SchoolUtil.getSpellSchoolsFromGear(stack);
        return gearSchools.contains(this.school);
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        float reduction = this.getReductionPercent(rarity, level);
        String schoolTranslationKey = "school." + this.school.getId().m_135827_() + "." + this.school.getId().m_135815_();
        return Component.m_237110_((String)"affix.otherworldapoth.mana_cost.desc", (Object[])new Object[]{Component.m_237115_((String)schoolTranslationKey).m_130948_(this.school.getDisplayName().m_7383_()), ManaCostAffix.fmt((float)(reduction * 100.0f))});
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        MutableComponent comp = this.getDescription(stack, rarity, level);
        float minReduction = this.getReductionPercent(rarity, 0.0f);
        float maxReduction = this.getReductionPercent(rarity, 1.0f);
        MutableComponent minComp = Component.m_237110_((String)"%s%%", (Object[])new Object[]{ManaCostAffix.fmt((float)(minReduction * 100.0f))});
        MutableComponent maxComp = Component.m_237110_((String)"%s%%", (Object[])new Object[]{ManaCostAffix.fmt((float)(maxReduction * 100.0f))});
        return comp.m_7220_((Component)ManaCostAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    public SchoolType getSchool() {
        return this.school;
    }

    public float getReductionPercent(LootRarity rarity, float level) {
        StepFunction func = this.values.get(rarity);
        return func != null ? func.get(level) : 0.0f;
    }
}

