/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworldapoth.LootCategories;
import dev.muon.otherworldapoth.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class MagicTelepathicAffix
extends Affix {
    public static final Codec<MagicTelepathicAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.CODEC.fieldOf("min_rarity").forGetter(a -> a.minRarity)).apply((Applicative)inst, MagicTelepathicAffix::new));
    protected LootRarity minRarity;

    public MagicTelepathicAffix(LootRarity minRarity) {
        super(AffixType.POTION);
        this.minRarity = minRarity;
    }

    public boolean enablesTelepathy() {
        return true;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        return Component.m_237115_((String)("affix." + String.valueOf(this.getId()) + ".desc.staff"));
    }

    public static void drops(LivingDropsEvent e) {
        LivingEntity living;
        ItemStack weapon;
        Projectile spell;
        DamageSource src = e.getSource();
        Entity directEntity = src.m_7640_();
        Entity causingEntity = src.m_7639_();
        boolean canTeleport = false;
        Vec3 targetPos = null;
        if (directEntity instanceof Projectile && (spell = (Projectile)directEntity).m_19749_() != null && (canTeleport = AffixHelper.streamAffixes(spell).anyMatch(AffixInstance::enablesTelepathy))) {
            targetPos = spell.m_19749_().m_20182_();
        }
        if (!canTeleport && causingEntity instanceof LivingEntity && (canTeleport = dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper.streamAffixes((ItemStack)(weapon = (living = (LivingEntity)causingEntity).m_21205_())).anyMatch(AffixInstance::enablesTelepathy))) {
            targetPos = living.m_20182_();
        }
        if (canTeleport) {
            for (ItemEntity item : e.getDrops()) {
                item.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                item.m_32010_(0);
            }
        }
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return LootCategories.isStaff(stack) && rarity.isAtLeast(this.minRarity);
    }
}

