/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class AffixHelper {
    private static final String AFFIX_DATA = "AffixData";
    private static final String AFFIXES = "Affixes";

    public static Map<DynamicHolder<? extends Affix>, AffixInstance> getAffixes(Projectile projectile) {
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> map = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>();
        CompoundTag afxData = projectile.getPersistentData().m_128469_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            DynamicHolder rarity = dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper.getRarity((CompoundTag)afxData);
            if (!rarity.isBound()) {
                rarity = RarityRegistry.getMinRarity();
            }
            for (String key : affixes.m_128431_()) {
                DynamicHolder affix = AffixRegistry.INSTANCE.holder(new ResourceLocation(key));
                if (!affix.isBound()) continue;
                float lvl = affixes.m_128457_(key);
                map.put((DynamicHolder<? extends Affix>)affix, new AffixInstance(affix, ItemStack.f_41583_, rarity, lvl));
            }
        }
        return map;
    }

    public static Stream<AffixInstance> streamAffixes(Projectile projectile) {
        return AffixHelper.getAffixes(projectile).values().stream();
    }
}

