/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.affix;

import dev.muon.otherworldapoth.affix.MagicTelepathicAffix;
import dev.muon.otherworldapoth.affix.ManaCostAffix;
import dev.muon.otherworldapoth.affix.SocketBonusAffix;
import dev.muon.otherworldapoth.affix.SpellEffectAffix;
import dev.muon.otherworldapoth.affix.SpellLevelAffix;
import dev.muon.otherworldapoth.affix.SpellTriggerAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.event.GetItemSocketsEvent;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AffixEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        MagicTelepathicAffix.drops(e);
    }

    @SubscribeEvent
    public void hookAddSocketsAffix(GetItemSocketsEvent event) {
        ItemStack stack = event.getStack();
        int affixBonus = StreamSupport.stream(AffixHelper.streamAffixes((ItemStack)stack).spliterator(), false).filter(inst -> inst.affix().get() instanceof SocketBonusAffix).mapToInt(inst -> {
            SocketBonusAffix affix = (SocketBonusAffix)((Object)((Object)inst.affix().get()));
            return affix.getBonusSockets((LootRarity)inst.rarity().get(), inst.level());
        }).sum();
        if (affixBonus > 0) {
            event.setSockets(event.getSockets() + affixBonus);
        }
    }

    @SubscribeEvent
    public void hookSpellDamageAffix(SpellDamageEvent event) {
        LivingEntity living;
        LivingEntity caster;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Entity entity = event.getSpellDamageSource().m_7639_();
        LivingEntity livingEntity = caster = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        if (caster == null) {
            return;
        }
        for (ItemStack stack : caster.m_20158_()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Object patt2378$temp = inst.affix().get();
                if (patt2378$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)((Object)((Object)patt2378$temp));
                    if (affix.target == SpellEffectAffix.SpellTarget.SPELL_DAMAGE_TARGET) {
                        affix.applyEffect(event.getEntity(), (LootRarity)inst.rarity().get(), inst.level());
                    } else if (affix.target == SpellEffectAffix.SpellTarget.SPELL_DAMAGE_SELF) {
                        affix.applyEffect(caster, (LootRarity)inst.rarity().get(), inst.level());
                    }
                } else {
                    Object patt2861$temp = inst.affix().get();
                    if (patt2861$temp instanceof SpellTriggerAffix) {
                        SpellTriggerAffix affix = (SpellTriggerAffix)((Object)((Object)patt2861$temp));
                        if (affix.trigger == SpellTriggerAffix.TriggerType.SPELL_DAMAGE) {
                            LivingEntity target = affix.target.map(targetType -> switch (targetType) {
                                default -> throw new IncompatibleClassChangeError();
                                case SpellTriggerAffix.TargetType.SELF -> caster;
                                case SpellTriggerAffix.TargetType.TARGET -> event.getEntity();
                            }).orElse(event.getEntity());
                            affix.triggerSpell(caster, target, (LootRarity)inst.rarity().get(), inst.level());
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void hookSpellHealAffix(SpellHealEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity caster = event.getEntity();
        for (ItemStack stack : caster.m_20158_()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Object patt3724$temp = inst.affix().get();
                if (patt3724$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)((Object)((Object)patt3724$temp));
                    if (affix.target == SpellEffectAffix.SpellTarget.SPELL_HEAL_TARGET) {
                        affix.applyEffect(event.getTargetEntity(), (LootRarity)inst.rarity().get(), inst.level());
                    } else if (affix.target == SpellEffectAffix.SpellTarget.SPELL_HEAL_SELF) {
                        affix.applyEffect(caster, (LootRarity)inst.rarity().get(), inst.level());
                    }
                } else {
                    Object patt4209$temp = inst.affix().get();
                    if (patt4209$temp instanceof SpellTriggerAffix) {
                        SpellTriggerAffix affix = (SpellTriggerAffix)((Object)((Object)patt4209$temp));
                        if (affix.trigger == SpellTriggerAffix.TriggerType.SPELL_HEAL) {
                            LivingEntity target = affix.target.map(targetType -> switch (targetType) {
                                default -> throw new IncompatibleClassChangeError();
                                case SpellTriggerAffix.TargetType.SELF -> caster;
                                case SpellTriggerAffix.TargetType.TARGET -> event.getTargetEntity();
                            }).orElse(event.getTargetEntity());
                            affix.triggerSpell(caster, target, (LootRarity)inst.rarity().get(), inst.level());
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void hookSpellLevelAffix(ModifySpellLevelEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        SchoolType school = event.getSpell().getSchoolType();
        int totalBonus = StreamSupport.stream(event.getEntity().m_20158_().spliterator(), false).flatMap(stack -> StreamSupport.stream(AffixHelper.streamAffixes((ItemStack)stack).spliterator(), false)).filter(inst -> {
            SpellLevelAffix affix;
            Object patt5189$temp = inst.affix().get();
            return patt5189$temp instanceof SpellLevelAffix && (affix = (SpellLevelAffix)((Object)((Object)patt5189$temp))).getSchool() == school;
        }).mapToInt(inst -> ((SpellLevelAffix)((Object)((Object)inst.affix().get()))).getBonusLevel((LootRarity)inst.rarity().get(), inst.level())).sum();
        if (totalBonus > 0) {
            event.addLevels(totalBonus);
        }
    }

    @SubscribeEvent
    public void onChangeMana(ChangeManaEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        MagicData magicData = event.getMagicData();
        SpellData castingSpell = magicData.getCastingSpell();
        if (castingSpell == null || event.getNewMana() >= event.getOldMana()) {
            return;
        }
        AbstractSpell spell = castingSpell.getSpell();
        if (spell == null) {
            return;
        }
        SchoolType spellSchool = spell.getSchoolType();
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41619_()) {
            return;
        }
        float totalReduction = 0.0f;
        Map affixes = AffixHelper.getAffixes((ItemStack)mainHand);
        for (AffixInstance instance : affixes.values()) {
            ManaCostAffix manaCostAffix;
            Affix affix;
            if (!instance.isValid() || !instance.affix().isBound() || !((affix = (Affix)instance.affix().get()) instanceof ManaCostAffix) || (manaCostAffix = (ManaCostAffix)affix).getSchool() != spellSchool) continue;
            float reduction = manaCostAffix.getReductionPercent((LootRarity)instance.rarity().get(), instance.level());
            totalReduction += reduction;
        }
        if (totalReduction > 0.0f) {
            float manaCost = event.getOldMana() - event.getNewMana();
            float reducedCost = manaCost * (1.0f - Math.min(totalReduction, 0.9f));
            float newManaValue = event.getOldMana() - reducedCost;
            event.setNewMana(newManaValue);
        }
    }
}

