/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth;

import dev.muon.otherworldapoth.LootCategories;
import dev.muon.otherworldapoth.affix.AffixEvents;
import dev.muon.otherworldapoth.affix.MagicTelepathicAffix;
import dev.muon.otherworldapoth.affix.ManaCostAffix;
import dev.muon.otherworldapoth.affix.SchoolAttributeAffix;
import dev.muon.otherworldapoth.affix.SocketBonusAffix;
import dev.muon.otherworldapoth.affix.SpellEffectAffix;
import dev.muon.otherworldapoth.affix.SpellLevelAffix;
import dev.muon.otherworldapoth.affix.SpellTriggerAffix;
import dev.muon.otherworldapoth.config.OWApothConfig;
import dev.muon.otherworldapoth.loot.LeveledAffixLootModifier;
import dev.muon.otherworldapoth.loot.LeveledGemLootModifier;
import dev.muon.otherworldapoth.loot.LootEvents;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="otherworldapoth")
public class OtherworldApoth {
    public static final String MODID = "otherworldapoth";
    public static final Logger LOGGER = LogManager.getLogger();

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }

    public OtherworldApoth(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerLootModifiers);
        OWApothConfig.init();
        LootCategories.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MinecraftForge.EVENT_BUS.register((Object)new AffixEvents());
            MinecraftForge.EVENT_BUS.register((Object)new LootEvents());
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("attribute"), SchoolAttributeAffix.CODEC);
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("spell_effect"), SpellEffectAffix.CODEC);
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("magic_telepathic"), MagicTelepathicAffix.CODEC);
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("spell_level"), SpellLevelAffix.CODEC);
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("spell_trigger"), SpellTriggerAffix.CODEC);
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("mana_cost"), ManaCostAffix.CODEC);
            AffixRegistry.INSTANCE.registerCodec(OtherworldApoth.loc("socket_bonus"), SocketBonusAffix.CODEC);
        });
    }

    private void registerLootModifiers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS)) {
            event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, OtherworldApoth.loc("leveled_affixes"), () -> LeveledAffixLootModifier.CODEC);
            event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, OtherworldApoth.loc("leveled_gems"), () -> LeveledGemLootModifier.CODEC);
        }
    }
}

