/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;

public class FoodServingRecipe
extends CustomRecipe {
    public FoodServingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack cookingPotStack = ItemStack.f_41583_;
        ItemStack containerStack = ItemStack.f_41583_;
        ItemStack secondStack = ItemStack.f_41583_;
        for (int index = 0; index < container.m_6643_(); ++index) {
            ItemStack mealStack;
            ItemStack selectedStack = container.m_8020_(index);
            if (selectedStack.m_41619_()) continue;
            if (cookingPotStack.m_41619_() && !(mealStack = CookingPotBlockEntity.getMealFromItem(selectedStack)).m_41619_()) {
                cookingPotStack = selectedStack;
                containerStack = CookingPotBlockEntity.getContainerFromItem(selectedStack);
                continue;
            }
            if (secondStack.m_41619_()) {
                secondStack = selectedStack;
                continue;
            }
            return false;
        }
        return !cookingPotStack.m_41619_() && !secondStack.m_41619_() && secondStack.m_150930_(containerStack.m_41720_());
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack selectedStack = container.m_8020_(i);
            if (selectedStack.m_41619_() || !selectedStack.m_150930_((Item)ModItems.COOKING_POT.get())) continue;
            ItemStack resultStack = CookingPotBlockEntity.getMealFromItem(selectedStack).m_41777_();
            resultStack.m_41764_(1);
            return resultStack;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remainders = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainders.size(); ++i) {
            ItemStack selectedStack = container.m_8020_(i);
            if (selectedStack.hasCraftingRemainingItem()) {
                remainders.set(i, (Object)selectedStack.getCraftingRemainingItem());
                continue;
            }
            if (!selectedStack.m_150930_((Item)ModItems.COOKING_POT.get())) continue;
            CookingPotBlockEntity.takeServingFromItem(selectedStack);
            ItemStack newCookingPotStack = selectedStack.m_41777_();
            newCookingPotStack.m_41764_(1);
            remainders.set(i, (Object)newCookingPotStack);
            break;
        }
        return remainders;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FOOD_SERVING.get();
    }
}

