/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util;

import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummoningUtils {
    public static void handlePetSummoning(ServerPlayer player) {
        ItemStack trinket;
        if (CurioUtils.isWearingFamiliarTrinket((LivingEntity)player) && (trinket = CurioUtils.getFamiliarTrinket((LivingEntity)player)) != null && trinket.m_41782_()) {
            CompoundTag nbt = trinket.m_41783_();
            boolean isSummoned = nbt.m_128471_("isSummoned");
            if (isSummoned) {
                AbstractSpellCastingPet pet;
                ServerLevel world2;
                Entity entity;
                UUID petUUID = nbt.m_128342_("petUUID");
                Level level = player.m_9236_();
                if (level instanceof ServerLevel && (entity = (world2 = (ServerLevel)level).m_8791_(petUUID)) != null && entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().m_7306_((Entity)player)) {
                    nbt.m_128350_("currentHealth", pet.m_21223_());
                    nbt.m_128379_("isSummoned", false);
                    pet.m_20240_(nbt);
                    trinket.m_41751_(nbt);
                    pet.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                AbstractSpellCastingPet pet;
                ServerLevel world;
                Entity entity;
                Level world2 = player.m_9236_();
                if (world2 instanceof ServerLevel && (entity = SummoningUtils.getEntityFromStack(trinket, (Level)(world = (ServerLevel)world2), true)) instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().m_7306_((Entity)player)) {
                    float currentHealth = nbt.m_128457_("currentHealth");
                    pet.m_21153_(currentHealth);
                    float yrot = 6.281f + player.m_146908_() * ((float)Math.PI / 180);
                    Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)player.m_146892_().m_82549_(new Vec3((double)(3.0f * Mth.m_14089_((float)yrot)), 0.0, (double)(3.0f * Mth.m_14031_((float)yrot)))), (int)10);
                    pet.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
                    pet.m_146922_(player.m_146908_());
                    pet.m_146867_();
                    world.m_7967_(entity);
                    nbt.m_128379_("isSummoned", true);
                    pet.m_20240_(nbt);
                    trinket.m_41751_(nbt);
                }
            }
        }
    }

    @Nullable
    public static Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        CompoundTag nbt;
        EntityType type;
        if (stack.m_41782_() && (type = (EntityType)EntityType.m_20632_((String)(nbt = stack.m_41783_()).m_128461_("entity")).orElse(null)) != null) {
            Entity entity = type.m_20615_(world);
            if (withInfo) {
                entity.m_20258_(nbt);
            } else if (!type.m_20654_()) {
                return null;
            }
            return entity;
        }
        return null;
    }
}

