/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.recipe_types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.compat.ItemMultiSet;
import net.alshanex.alshanex_familiars.registry.RecipeRegistry;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class RitualRecipeType
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient centralItem;
    private final List<RitualIngredient> inputs;
    private final ItemStack result;
    private final Holder<ParticleType<?>> defaultParticle;

    public RitualRecipeType(ResourceLocation id, Ingredient centralItem, List<RitualIngredient> inputs, ItemStack result, Holder<ParticleType<?>> defaultParticle) {
        this.id = id;
        this.centralItem = centralItem;
        this.inputs = inputs;
        this.result = result;
        this.defaultParticle = defaultParticle;
    }

    public Ingredient centralItem() {
        return this.centralItem;
    }

    public List<RitualIngredient> inputs() {
        return this.inputs;
    }

    public ItemStack result() {
        return this.result.m_41777_();
    }

    public Holder<ParticleType<?>> defaultParticle() {
        return this.defaultParticle;
    }

    public boolean m_5818_(Container inv, Level level) {
        if (!(inv instanceof RitualContainer)) {
            return false;
        }
        RitualContainer input = (RitualContainer)inv;
        if (!this.centralItem.test(input.centralItem)) {
            return false;
        }
        HashMap<Item, Integer> requiredCounts = new HashMap<Item, Integer>();
        for (RitualIngredient ritualIngredient : this.inputs) {
            requiredCounts.merge(ritualIngredient.item(), ritualIngredient.count(), Integer::sum);
        }
        for (Map.Entry entry : requiredCounts.entrySet()) {
            if (input.inputItems.getCount((Item)entry.getKey()) >= (Integer)entry.getValue()) continue;
            return false;
        }
        int totalRecipeCount = requiredCounts.values().stream().mapToInt(Integer::intValue).sum();
        return input.inputItems.size() == totalRecipeCount;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.RITUAL_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class RitualContainer
    extends SimpleContainer {
        public final ItemStack centralItem;
        public final ItemMultiSet inputItems;

        public RitualContainer(ItemStack centralItem, ItemMultiSet inputItems) {
            super(1);
            this.centralItem = centralItem;
            this.inputItems = inputItems;
        }
    }

    public record RitualIngredient(Item item, int count, boolean consume) {
        public static final Codec<RitualIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(RitualIngredient::item), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(RitualIngredient::count), (App)Codec.BOOL.optionalFieldOf("consume", (Object)true).forGetter(RitualIngredient::consume)).apply((Applicative)instance, RitualIngredient::new));

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)this.item);
            buf.m_130130_(this.count);
            buf.writeBoolean(this.consume);
        }

        public static RitualIngredient fromNetwork(FriendlyByteBuf buf) {
            Item item = (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            int count = buf.m_130242_();
            boolean consume = buf.readBoolean();
            return new RitualIngredient(item, count, consume);
        }
    }

    public static class Builder
    implements RecipeBuilder {
        ParticleType<?> defaultParticle = ParticleTypes.f_123783_;
        Ingredient centralItem = null;
        List<RitualIngredient> inputs = new ArrayList<RitualIngredient>();
        ItemStack result = null;

        public static Builder builder() {
            return new Builder();
        }

        public Builder withInput(Item input, int count, boolean consume) {
            this.inputs.add(new RitualIngredient(input, count, consume));
            return this;
        }

        public Builder withInput(Item input) {
            return this.withInput(input, 1, true);
        }

        public Builder withCentralItem(Item item) {
            this.centralItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            return this;
        }

        public Builder withReturnItem(Item returned) {
            this.result = new ItemStack((ItemLike)returned);
            return this;
        }

        public Builder withParticles(ParticleType<?> particle) {
            this.defaultParticle = particle;
            return this;
        }

        public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
            return this;
        }

        public RecipeBuilder m_126145_(@Nullable String groupName) {
            return this;
        }

        public Item m_142372_() {
            return this.result.m_41720_();
        }

        public void m_126140_(Consumer<FinishedRecipe> recipeOutput, final ResourceLocation id) {
            recipeOutput.accept(new FinishedRecipe(){

                public void m_7917_(JsonObject json) {
                    json.add("central_item", centralItem.m_43942_());
                    JsonArray inputsArray = new JsonArray();
                    for (RitualIngredient input : inputs) {
                        inputsArray.add((JsonElement)RitualIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)input).getOrThrow(false, e -> {}));
                    }
                    json.add("inputs", (JsonElement)inputsArray);
                    JsonObject resultObj = new JsonObject();
                    resultObj.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)result.m_41720_()).toString());
                    if (result.m_41613_() > 1) {
                        resultObj.addProperty("count", (Number)result.m_41613_());
                    }
                    if (result.m_41782_()) {
                        resultObj.addProperty("nbt", result.m_41783_().toString());
                    }
                    json.add("result", (JsonElement)resultObj);
                    if (defaultParticle != ParticleTypes.f_123783_) {
                        json.addProperty("particle_type", BuiltInRegistries.f_257034_.m_7981_(defaultParticle).toString());
                    }
                }

                public ResourceLocation m_6445_() {
                    return id;
                }

                public RecipeSerializer<?> m_6637_() {
                    return (RecipeSerializer)RecipeRegistry.RITUAL_RECIPE_SERIALIZER.get();
                }

                public JsonObject m_5860_() {
                    return null;
                }

                public ResourceLocation m_6448_() {
                    return null;
                }
            });
        }
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipeType> {
        public RitualRecipeType fromJson(ResourceLocation id, JsonObject json) {
            Ingredient central = Ingredient.m_43917_((JsonElement)json.get("central_item"));
            ArrayList<RitualIngredient> inputs = new ArrayList<RitualIngredient>();
            if (json.has("inputs")) {
                JsonArray inputsArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
                for (JsonElement element : inputsArray) {
                    inputs.add((RitualIngredient)RitualIngredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(e -> AlshanexFamiliarsMod.LOGGER.error("Failed to parse ritual ingredient: " + e)).orElseThrow(() -> new IllegalStateException("Failed to parse ritual ingredient")));
                }
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            Holder particle = BuiltInRegistries.f_257034_.m_263177_((Object)ParticleTypes.f_123783_);
            if (json.has("particle_type")) {
                ResourceLocation particleLoc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"particle_type"));
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256890_, (ResourceLocation)particleLoc);
                particle = BuiltInRegistries.f_257034_.m_203636_(key).map(h -> h).orElse(particle);
            }
            return new RitualRecipeType(id, central, inputs, result, particle);
        }

        @Nullable
        public RitualRecipeType fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient central = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int size = buffer.m_130242_();
            ArrayList<RitualIngredient> inputs = new ArrayList<RitualIngredient>(size);
            for (int i = 0; i < size; ++i) {
                inputs.add(RitualIngredient.fromNetwork(buffer));
            }
            ItemStack result = buffer.m_130267_();
            ParticleType pt = (ParticleType)buffer.m_236816_((IdMap)BuiltInRegistries.f_257034_);
            Holder particle = BuiltInRegistries.f_257034_.m_263177_(pt != null ? pt : ParticleTypes.f_123783_);
            return new RitualRecipeType(id, central, inputs, result, particle);
        }

        public void toNetwork(FriendlyByteBuf buffer, RitualRecipeType recipe) {
            recipe.centralItem.m_43923_(buffer);
            buffer.m_130130_(recipe.inputs.size());
            for (RitualIngredient input : recipe.inputs) {
                input.toNetwork(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)((ParticleType)recipe.defaultParticle.m_203334_()));
        }
    }
}

