/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item.curios;

import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import java.util.List;
import java.util.UUID;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFamiliarTrinket
extends SimpleDescriptiveCurio {
    private static final Component DESCRIPTION = Component.m_237115_((String)"item.alshanex_familiars.familiar_trinket.desc").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});

    public AbstractFamiliarTrinket(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!this.isValidPet(target)) {
            return InteractionResult.FAIL;
        }
        if (!this.bind(stack, target, playerIn)) {
            return InteractionResult.FAIL;
        }
        playerIn.m_6674_(hand);
        playerIn.m_21008_(hand, stack);
        return InteractionResult.SUCCESS;
    }

    protected boolean isValidPet(LivingEntity target) {
        return target instanceof AbstractSpellCastingPet;
    }

    public List<Component> getSlotsTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.add(DESCRIPTION);
        return tooltips;
    }

    public boolean bind(ItemStack stack, LivingEntity target, Player player) {
        AbstractSpellCastingPet pet;
        if (target.m_20193_().f_46443_) {
            return false;
        }
        if (!(target instanceof AbstractSpellCastingPet) || (pet = (AbstractSpellCastingPet)target).getSummoner() == null || !pet.getSummoner().m_7306_((Entity)player)) {
            return false;
        }
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            boolean isSummoned = false;
            if (!nbt.m_128441_("isSummoned")) {
                return false;
            }
            isSummoned = nbt.m_128471_("isSummoned");
            if (isSummoned) {
                UUID petUUID = nbt.m_128342_("petUUID");
                stack.m_41751_(new CompoundTag());
                if (!target.m_20148_().equals(petUUID)) {
                    CompoundTag nbtSwap = new CompoundTag();
                    nbtSwap.m_128362_("petUUID", target.m_20148_());
                    if (target.m_8077_()) {
                        nbtSwap.m_128359_("name", target.m_7770_().getString());
                    }
                    nbtSwap.m_128350_("currentHealth", target.m_21223_());
                    nbtSwap.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
                    nbtSwap.m_128379_("isSummoned", true);
                    target.m_20240_(nbtSwap);
                    stack.m_41751_(nbtSwap);
                }
                return true;
            }
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("petUUID", target.m_20148_());
        if (target.m_8077_()) {
            nbt.m_128359_("name", target.m_7770_().getString());
        }
        nbt.m_128350_("currentHealth", target.m_21223_());
        nbt.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
        nbt.m_128379_("isSummoned", true);
        target.m_20240_(nbt);
        stack.m_41751_(nbt);
        return true;
    }

    public String getID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt.m_128441_("name")) {
            return nbt.m_128461_("name");
        }
        return nbt.m_128461_("entity");
    }

    public Component m_7626_(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return Component.m_237115_((String)super.m_5671_(stack));
        }
        return Component.m_237115_((String)super.m_5671_(stack)).m_130946_(" (" + this.getID(stack) + ")");
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("entity");
    }
}

