/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.event;

import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.Random;
import net.alshanex.alshanex_familiars.entity.BardPetEntity;
import net.alshanex.alshanex_familiars.entity.PlaguePetEntity;
import net.alshanex.alshanex_familiars.entity.ScorcherPetEntity;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.AFSchoolRegistry;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="alshanex_familiars")
public class ServerEvents {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        AbstractSpellCastingPet pet;
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && (livingEntity = pet.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (CurioUtils.isWearingCurio(pet.getSummoner(), (Item)ItemRegistry.COMPLETE_SOUL_CURIO.get()) && magicData.getMana() >= 80.0f) {
                pet.m_21153_(pet.m_21233_() / 2.0f);
                float newMana = Math.max(magicData.getMana() - 80.0f, 0.0f);
                magicData.setMana(newMana);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new SyncManaPacket(magicData));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCasted(SpellOnCastEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!player2.m_9236_().f_46443_ && player2.m_21205_().m_150930_((Item)ItemRegistry.BARD_HARP.get()) && event.getSchoolType() == AFSchoolRegistry.SOUND.get()) {
                int radiusSqr = 16;
                player2.m_9236_().m_6443_(LivingEntity.class, new AABB(player2.m_20182_().m_82492_(4.0, 4.0, 4.0), player2.m_20182_().m_82520_(4.0, 4.0, 4.0)), livingEntity -> {
                    AbstractSpellCastingPet pet;
                    return livingEntity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)((Object)livingEntity)).getSummoner() == null && ServerEvents.horizontalDistanceSqr(livingEntity, player2.m_20182_()) < (float)radiusSqr;
                }).forEach(livingEntity -> {
                    BardPetEntity bard = new BardPetEntity((EntityType<? extends AbstractTerrestrianSpellCastingPet>)((EntityType)EntityRegistry.BARD_PET.get()), player2.m_9236_());
                    bard.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                    bard.m_146922_(livingEntity.m_146908_());
                    player2.m_9236_().m_7967_((Entity)bard);
                    MagicManager.spawnParticles((Level)player2.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(AFSchoolRegistry.SOUND.get().getTargetingColor(), 2.0f), (double)livingEntity.m_20185_(), (double)(livingEntity.m_20186_() + (double)0.165f), (double)livingEntity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                    livingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                });
            }
        }
    }

    private static float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.m_20185_() - vec3.f_82479_;
        double dz = livingEntity.m_20189_() - vec3.f_82481_;
        return (float)(dx * dx + dz * dz);
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingDamageEvent event) {
        LivingEntity entity;
        AbstractSpellCastingPet pet;
        LivingEntity livingEntity;
        if (event.getEntity() instanceof ScorcherPetEntity && event.getSource().m_7639_() != null && (livingEntity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity entity2 = livingEntity;
            entity2.m_7311_(100);
        }
        if ((livingEntity = event.getEntity()) instanceof PlaguePetEntity) {
            Entity entity3;
            pet = (PlaguePetEntity)livingEntity;
            if (event.getSource().m_7639_() != null && (entity3 = event.getSource().m_7639_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity3;
                Vec3 vec3 = entity.m_20184_();
                double d0 = entity.m_20185_() + vec3.f_82479_ - pet.m_20185_();
                double d1 = entity.m_20188_() - (double)1.1f - pet.m_20186_();
                double d2 = entity.m_20189_() + vec3.f_82481_ - pet.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                ThrownPotion thrownpotion = new ThrownPotion(pet.m_9236_(), (LivingEntity)pet);
                thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)Potions.f_43586_));
                thrownpotion.m_146926_(thrownpotion.m_146909_() - 20.0f);
                thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
                pet.triggerAnim("block_controller", "block");
                pet.m_9236_().m_7967_((Entity)thrownpotion);
            }
        }
        if ((entity = event.getEntity()) instanceof AbstractSpellCastingPet) {
            Random random;
            pet = (AbstractSpellCastingPet)entity;
            if (pet.getEnragedStacks() > 0 && (random = new Random()).nextInt(100) < 10) {
                pet.setEnragedStacks(pet.getEnragedStacks() - 1);
                pet.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.HEARTSTOP.get(), 100, 0, false, false, true));
                pet.triggerAnim("interact_controller", "interact");
                MagicManager.spawnParticles((Level)pet.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.BLOOD.get()).getTargetingColor(), 2.0f), (double)pet.m_20185_(), (double)(pet.m_20186_() + (double)0.165f), (double)pet.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            }
            if (pet.getIsBlocking().booleanValue() && (random = new Random()).nextInt(100) < 5) {
                event.setAmount(0.0f);
                pet.triggerAnim("block_controller", "block");
                MagicManager.spawnParticles((Level)pet.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)pet.m_20185_(), (double)(pet.m_20186_() + (double)0.165f), (double)pet.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                pet.m_9236_().m_6263_(null, pet.m_20185_(), pet.m_20186_(), pet.m_20189_(), SoundEvents.f_12346_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }
}

