/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.sound;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class HarpExplosionEntity
extends AoeEntity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int age;
    private float damage;

    public HarpExplosionEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public HarpExplosionEntity(Level level, LivingEntity owner, float damage) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.HARP_EXPLOSION.get()), level);
        this.setOwner(owner);
        this.setDamage(damage);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.age == 1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.DESTRUCTION_SYMPHONY_PARTICLE.get(), this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (this.age == 26) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.HARP_EXPLOSION_PARTICLE.get(), this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.age > 60) {
                this.m_146870_();
            }
            if (this.age <= 20) {
                CylinderParticleManager.spawnParticlesAtBlockPos(this.m_9236_(), this.m_20182_(), 50, (ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 4.0, 0.0, 0.0);
            }
            if (this.age == 26) {
                float explosionRadius = 4.0f;
                float explosionRadiusSqr = explosionRadius * explosionRadius;
                List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius), entity -> this.getOwner() != null && !entity.m_7306_((Entity)this.getOwner()));
                Vec3 losPoint = Utils.raycastForBlock((Level)this.m_9236_(), (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82520_(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
                for (Entity entity2 : entities) {
                    double distanceSqr = entity2.m_20238_(this.m_20182_());
                    if (!(distanceSqr < (double)explosionRadiusSqr) || !Utils.hasLineOfSight((Level)this.m_9236_(), (Vec3)losPoint, (Vec3)entity2.m_20191_().m_82399_(), (boolean)true)) continue;
                    double p = 1.0 - distanceSqr / (double)explosionRadiusSqr;
                    float damage = (float)((double)this.damage * p);
                    DamageSources.applyDamage((Entity)entity2, (float)damage, (DamageSource)((AbstractSpell)PetSpellRegistry.EXPLOSION_MELODY.get()).getDamageSource((Entity)this, (Entity)this.getOwner()));
                    if (!(entity2 instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity2;
                    target.m_246865_(new Vec3(0.0, 1.0, 0.0));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50, 3, false, false));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 50, 3, false, false));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 50, 3, false, false));
                }
                if (((Boolean)ServerConfigs.SPELL_GREIFING.get()).booleanValue()) {
                    Explosion explosion = new Explosion(this.m_9236_(), null, (DamageSource)((AbstractSpell)SpellRegistry.FIREBALL_SPELL.get()).getDamageSource((Entity)this, (Entity)this.getOwner()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosionRadius / 2.0f, true, Explosion.BlockInteraction.DESTROY);
                    if (!ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
                        explosion.m_46061_();
                        explosion.m_46075_(false);
                    }
                }
                this.m_5496_((SoundEvent)AFSoundRegistry.HARP_EXPLOSION.get(), 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
            }
        }
        ++this.age;
    }

    public void applyEffect(LivingEntity target) {
        if (!target.m_21023_(MobEffects.f_19597_)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2, false, false));
        }
    }

    public float getParticleCount() {
        return 0.0f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.age = pCompound.m_128451_("Age");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.age);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }
}

