/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.misc;

import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MemoryFragmentEntity
extends Entity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(MemoryFragmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private double tx;
    private double ty;
    private double tz;
    private int life;
    private boolean surviveAfterDeath;

    public MemoryFragmentEntity(EntityType<? extends MemoryFragmentEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MemoryFragmentEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends MemoryFragmentEntity>)((EntityType)EntityRegistry.MEMORY_FRAGMENT.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    public void setItem(ItemStack pStack) {
        if (!pStack.m_150930_((Item)ItemRegistry.MEMORY_FRAGMENT.get()) || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)pStack.m_255036_(1));
        }
    }

    private ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack item = this.getItemRaw();
        return item.m_41619_() ? new ItemStack((ItemLike)ItemRegistry.MEMORY_FRAGMENT.get()) : item;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public boolean m_6783_(double pDistance) {
        double radius = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(radius)) {
            radius = 4.0;
        }
        return pDistance < (radius *= 64.0) * radius;
    }

    public void signalTo(BlockPos pPos) {
        double distZ;
        double pPosX = pPos.m_123341_();
        int pPosY = pPos.m_123342_();
        double pPosZ = pPos.m_123343_();
        double distX = pPosX - this.m_20185_();
        double sqrt = Math.sqrt(distX * distX + (distZ = pPosZ - this.m_20189_()) * distZ);
        if (sqrt > 12.0) {
            this.tx = this.m_20185_() + distX / sqrt * 12.0;
            this.tz = this.m_20189_() + distZ / sqrt * 12.0;
            this.ty = this.m_20186_() + 8.0;
        } else {
            this.tx = pPosX;
            this.ty = pPosY;
            this.tz = pPosZ;
        }
        this.life = 0;
        this.surviveAfterDeath = this.f_19796_.m_188503_(5) > 0;
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.m_20334_(pX, pY, pZ);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double sqrt = Math.sqrt(pX * pX + pZ * pZ);
            this.m_146922_((float)(Mth.m_14136_((double)pX, (double)pZ) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)pY, (double)sqrt) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 deltaMovement = this.m_20184_();
        double moveX = this.m_20185_() + deltaMovement.f_82479_;
        double moveY = this.m_20186_() + deltaMovement.f_82480_;
        double moveZ = this.m_20189_() + deltaMovement.f_82481_;
        double horizontalDistance = deltaMovement.m_165924_();
        this.m_146926_(MemoryFragmentEntity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)deltaMovement.f_82480_, (double)horizontalDistance) * 57.2957763671875)));
        this.m_146922_(MemoryFragmentEntity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)deltaMovement.f_82479_, (double)deltaMovement.f_82481_) * 57.2957763671875)));
        if (!this.m_9236_().f_46443_) {
            double finalX = this.tx - moveX;
            double finalZ = this.tz - moveZ;
            float sqrt = (float)Math.sqrt(finalX * finalX + finalZ * finalZ);
            float atan2 = (float)Mth.m_14136_((double)finalZ, (double)finalX);
            double lerp = Mth.m_14139_((double)0.0025, (double)horizontalDistance, (double)sqrt);
            double deltaY = deltaMovement.f_82480_;
            if (sqrt < 1.0f) {
                lerp *= 0.8;
                deltaY *= 0.8;
            }
            int finalY = this.m_20186_() < this.ty ? 1 : -1;
            deltaMovement = new Vec3(Math.cos(atan2) * lerp, deltaY + ((double)finalY - deltaY) * (double)0.015f, Math.sin(atan2) * lerp);
            this.m_20256_(deltaMovement);
        }
        float angle = 0.25f;
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, moveX - deltaMovement.f_82479_ * 0.25, moveY - deltaMovement.f_82480_ * 0.25, moveZ - deltaMovement.f_82481_ * 0.25, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
            }
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175826_, moveX - deltaMovement.f_82479_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, moveY - deltaMovement.f_82480_ * 0.25 - 0.5, moveZ - deltaMovement.f_82481_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_6034_(moveX, moveY, moveZ);
            ++this.life;
            if (this.life > 80 && !this.m_9236_().f_46443_) {
                this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
                this.m_146870_();
            }
        } else {
            this.m_20343_(moveX, moveY, moveZ);
        }
    }

    protected static float lerpRotation(float pCurrentRotation, float pTargetRotation) {
        while (pTargetRotation - pCurrentRotation < -180.0f) {
            pCurrentRotation -= 360.0f;
        }
        while (pTargetRotation - pCurrentRotation >= 180.0f) {
            pCurrentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)pCurrentRotation, (float)pTargetRotation);
    }

    public void m_7380_(CompoundTag pCompound) {
        ItemStack item = this.getItemRaw();
        if (!item.m_41619_()) {
            pCompound.m_128365_("Item", (Tag)item.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        ItemStack item = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.setItem(item);
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_6097_() {
        return false;
    }
}

