/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.misc;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.EffectRegistry;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlueBirdEntity
extends PathfinderMob
implements GeoEntity,
IMagicSummon {
    private int effectAmplifier;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    private final RawAnimation walk = RawAnimation.begin().thenLoop("walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BlueBirdEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21364_ = 0;
    }

    public BlueBirdEntity(Level level, LivingEntity owner, int effectAmplifier) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntityRegistry.BLUE_BIRD.get()), level);
        this.effectAmplifier = effectAmplifier;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new BuffAllyGoal(this, () -> ((BlueBirdEntity)this).getSummoner(), this.effectAmplifier));
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, () -> ((BlueBirdEntity)this).getSummoner(), (double)0.9f, 10.0f, 3.0f, false, 25.0f));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new FlyingBirdWanderGoal(this, 60));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22280_, (double)0.15f).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6673_(DamageSource pSource) {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (SummonManager.getOwner((Entity)this) != null && this.f_19797_ % 5 == 0 && (entity = SummonManager.getOwner((Entity)this)) instanceof LivingEntity) {
            LivingEntity summoner = (LivingEntity)entity;
            if (summoner.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get())) {
                if (summoner.m_21124_((MobEffect)MobEffectRegistry.HASTENED.get()).m_19557_() < 500) {
                    summoner.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.HASTENED.get(), 500 - summoner.m_21124_((MobEffect)MobEffectRegistry.HASTENED.get()).m_19557_(), this.effectAmplifier, false, false, true));
                }
            } else {
                summoner.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.HASTENED.get(), 500, this.effectAmplifier, false, false, true));
            }
            if (summoner.m_21023_((MobEffect)EffectRegistry.BIRD_BUFF.get())) {
                if (summoner.m_21124_((MobEffect)EffectRegistry.BIRD_BUFF.get()).m_19557_() < 500) {
                    summoner.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BIRD_BUFF.get(), 500 - summoner.m_21124_((MobEffect)EffectRegistry.BIRD_BUFF.get()).m_19557_(), 0, false, false, true));
                }
            } else {
                summoner.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BIRD_BUFF.get(), 500, 0, false, false, true));
            }
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.m_6667_(pDamageSource);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void onUnSummon() {
        if (!this.m_9236_().f_46443_) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.m_146870_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate)});
    }

    private PlayState idlePredicate(AnimationState event) {
        if (event.isMoving()) {
            event.getController().setAnimation(this.walk);
            return PlayState.CONTINUE;
        }
        if (!event.isMoving()) {
            event.getController().setAnimation(this.idle);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected class BuffAllyGoal
    extends Goal {
        private final BlueBirdEntity bird;
        private LivingEntity ally;
        private final Supplier<Entity> petOwner;
        private final int effectAmplifier;

        public BuffAllyGoal(BlueBirdEntity bird, Supplier<Entity> owner, int effectAmplifier) {
            this.bird = bird;
            this.petOwner = owner;
            this.effectAmplifier = effectAmplifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            Entity owner = this.petOwner.get();
            if (owner == null) {
                return false;
            }
            if (this.ally != null) {
                return false;
            }
            this.ally = this.bird.m_9236_().m_6443_(LivingEntity.class, this.bird.m_20191_().m_82400_(15.0), livingEntity -> livingEntity != owner && Utils.shouldHealEntity((Entity)owner, (Entity)livingEntity) && !livingEntity.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get()) && !livingEntity.m_21023_((MobEffect)EffectRegistry.BIRD_BUFF.get())).stream().min(Comparator.comparingDouble(arg_0 -> ((BlueBirdEntity)this.bird).m_20270_(arg_0))).orElse(null);
            return this.ally != null;
        }

        public boolean m_8045_() {
            return this.ally != null && this.ally.m_6084_() && !this.ally.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get()) && !this.ally.m_21023_((MobEffect)EffectRegistry.BIRD_BUFF.get());
        }

        public void m_8056_() {
            this.bird.m_21573_().m_5624_((Entity)this.ally, 1.0);
        }

        public void m_8037_() {
            if (this.ally == null) {
                return;
            }
            if ((double)this.bird.m_20270_((Entity)this.ally) < 3.0) {
                this.bird.m_21563_().m_24960_((Entity)this.ally, 10.0f, 10.0f);
                if (!this.ally.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get())) {
                    this.ally.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.HASTENED.get(), 300, this.effectAmplifier, false, false, true));
                    this.ally.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BIRD_BUFF.get(), 300, 0, false, false, true));
                    if (!BlueBirdEntity.this.m_9236_().f_46443_) {
                        BlueBirdEntity.this.m_9236_().m_6263_(null, this.bird.m_20185_(), this.bird.m_20186_(), this.bird.m_20189_(), (SoundEvent)AFSoundRegistry.BIRD_CHIRP.get(), SoundSource.MUSIC, 1.0f, 1.0f);
                        MagicManager.spawnParticles((Level)BlueBirdEntity.this.m_9236_(), (ParticleOptions)((ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get()), (double)this.bird.m_20185_(), (double)this.bird.m_20186_(), (double)this.bird.m_20189_(), (int)5, (double)0.0, (double)0.0, (double)0.0, (double)0.18, (boolean)true);
                    }
                }
            } else {
                this.bird.m_21573_().m_5624_((Entity)this.ally, 1.0);
            }
        }

        public void m_8041_() {
            this.ally = null;
        }
    }

    class FlyingBirdWanderGoal
    extends Goal {
        private static final int WANDER_THRESHOLD = 22;
        private final BlueBirdEntity bird;
        private final int interval;
        private int cooldown;

        FlyingBirdWanderGoal(BlueBirdEntity bird, int interval) {
            this.bird = bird;
            this.interval = interval;
            this.cooldown = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return this.bird.m_21573_().m_26571_() && this.bird.m_217043_().m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return this.bird.m_21573_().m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                this.bird.m_21573_().m_26536_(this.bird.m_21573_().m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
            }
            this.cooldown = this.interval;
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3;
            if (this.bird.m_5448_() != null) {
                Vec3 targetPos = this.bird.m_5448_().m_20182_();
                vec3 = targetPos.m_82546_(this.bird.m_20182_()).m_82541_();
            } else {
                vec3 = this.bird.m_20252_(0.0f);
            }
            int i = 8;
            Vec3 randomPos = HoverRandomPos.m_148465_((PathfinderMob)this.bird, (int)i, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return randomPos != null ? randomPos : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.bird, (int)i, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }
}

