/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.util.ModTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class NecromancerPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/necromancer_pet.png");

    public NecromancerPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 60, 100).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), (AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get()), List.of(), List.of(), List.of((AbstractSpell)SpellRegistry.HEARTSTOP_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get(), 2000, 3000, 1, 4));
        this.f_21345_.m_25352_(2, (Goal)new UndeadChaosGoal(this, this::getSummoner, 10.0, 100));
        this.f_21345_.m_25352_(10, (Goal)new WitherifyGoal(this));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.f_21345_.m_262460_(goal -> goal instanceof WizardAttackGoal || goal instanceof UndeadChaosGoal || goal instanceof WitherifyGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 60, 100).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), (AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get()), List.of(), List.of(), List.of((AbstractSpell)SpellRegistry.HEARTSTOP_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get(), 2000, 3000, 1, 4));
        this.f_21345_.m_25352_(2, (Goal)new UndeadChaosGoal(this, this::getSummoner, 10.0, 100));
        this.f_21345_.m_25352_(10, (Goal)new WitherifyGoal(this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.m_150930_((Item)ItemRegistry.BLOOD_VIAL.get()) || item.m_150930_(Items.f_42500_);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected class UndeadChaosGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final Supplier<Entity> owner;
        private final double range;
        private final int interval;
        private int tickCounter;

        public UndeadChaosGoal(AbstractSpellCastingPet pet, Supplier<Entity> owner, double range, int interval) {
            this.pet = pet;
            this.owner = owner;
            this.range = range;
            this.interval = interval;
            this.tickCounter = 0;
        }

        public boolean m_8036_() {
            Entity owner = this.owner.get();
            if (owner == null) {
                return false;
            }
            return ++this.tickCounter >= this.interval;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.tickCounter = 0;
            NecromancerPetEntity.this.triggerAnim("interact_controller", "interact");
            Level level = this.pet.m_9236_();
            if (level.f_46443_) {
                return;
            }
            Entity owner = this.owner.get();
            List undeadEntities = level.m_6443_(LivingEntity.class, this.pet.m_20191_().m_82400_(this.range), entity -> entity != this.pet && entity != owner && entity.m_6336_() == MobType.f_21641_ && !entity.m_6095_().m_204039_(ModTags.NECROMANCER_BLACKLIST));
            if (undeadEntities.isEmpty()) {
                return;
            }
            List potentialTargets = level.m_6443_(LivingEntity.class, this.pet.m_20191_().m_82400_(this.range), entity -> entity != this.pet && entity != owner);
            if (potentialTargets.isEmpty()) {
                return;
            }
            for (LivingEntity undead : undeadEntities) {
                if (!(undead instanceof Mob)) continue;
                Mob mob = (Mob)undead;
                if (undead instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)undead;
                    if (summon.getSummoner() == null || summon.getSummoner() == owner || summon.getSummoner() == this.pet) continue;
                    this.selectTarget(potentialTargets, mob);
                    continue;
                }
                this.selectTarget(potentialTargets, mob);
            }
        }

        private void selectTarget(List<LivingEntity> potentialTargets, Mob mob) {
            ArrayList<LivingEntity> localTargets = new ArrayList<LivingEntity>(potentialTargets);
            localTargets.remove(mob);
            if (!localTargets.isEmpty()) {
                Random random = new Random();
                LivingEntity randomTarget = (LivingEntity)localTargets.get(random.nextInt(localTargets.size()));
                mob.m_6710_(randomTarget);
            }
        }
    }

    protected class WitherifyGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Skeleton skeleton;

        public WitherifyGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.skeleton != null) {
                return false;
            }
            this.skeleton = this.pet.m_9236_().m_45976_(Skeleton.class, this.pet.m_20191_().m_82400_(15.0)).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).m_20270_(arg_0))).orElse(null);
            return this.skeleton != null;
        }

        public boolean m_8045_() {
            return this.skeleton != null && this.skeleton.m_6084_();
        }

        public void m_8056_() {
            this.pet.m_21573_().m_5624_((Entity)this.skeleton, 1.0);
        }

        public void m_8037_() {
            if (this.skeleton == null) {
                return;
            }
            if ((double)this.pet.m_20270_((Entity)this.skeleton) < 3.0) {
                this.pet.m_21563_().m_24960_((Entity)this.skeleton, 10.0f, 10.0f);
                NecromancerPetEntity.this.triggerAnim("interact_controller", "interact");
                WitherSkeleton witherSkeleton = new WitherSkeleton(EntityType.f_20497_, this.pet.m_9236_());
                witherSkeleton.m_6034_(this.skeleton.m_20185_(), this.skeleton.m_20186_(), this.skeleton.m_20189_());
                witherSkeleton.m_6518_((ServerLevelAccessor)((ServerLevel)this.pet.m_9236_()), this.pet.m_9236_().m_6436_(this.skeleton.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.pet.m_9236_().m_7967_((Entity)witherSkeleton);
                MagicManager.spawnParticles((Level)NecromancerPetEntity.this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.skeleton.m_20185_(), (double)(this.skeleton.m_20186_() + (double)0.165f), (double)this.skeleton.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                this.skeleton.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.pet.m_21573_().m_5624_((Entity)this.skeleton, 1.0);
            }
        }

        public void m_8041_() {
            this.skeleton = null;
        }
    }
}

