/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.block.pedestal.PedestalTile;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.entity.generic.AbstractFlyingSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ArchmagePetEntity
extends AbstractFlyingSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/archmage_pet.png");

    public ArchmagePetEntity(EntityType<? extends AbstractFlyingSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ICICLE_SPELL.get(), (AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.SHIELD_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), 160, 300, 3, 5).setIsFlying());
        this.f_21345_.m_25352_(3, (Goal)new RerollScrollGoal(this, this::getSummoner, 10, 600));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.f_21345_.m_262460_(goal -> goal instanceof WizardAttackGoal || goal instanceof RerollScrollGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ICICLE_SPELL.get(), (AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.SHIELD_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), 160, 300, 3, 5));
        this.f_21345_.m_25352_(3, (Goal)new RerollScrollGoal(this, this::getSummoner, 10, 600));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    public void m_8119_() {
        List bullets;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0 && !this.m_9236_().f_46443_ && !(bullets = this.m_9236_().m_45976_(ShulkerBullet.class, this.m_20191_().m_82400_(10.0))).isEmpty()) {
            this.triggerAnim("interact_controller", "interact");
            for (ShulkerBullet bullet : bullets) {
                MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, (double)bullet.m_20185_(), (double)bullet.m_20186_(), (double)bullet.m_20189_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
                bullet.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.m_150930_((Item)ItemRegistry.MAGIC_CLOTH.get());
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected class RerollScrollGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int radius;
        private final int interval;
        private int tickCounter;

        public RerollScrollGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int radius, int interval) {
            this.controllerEntity = controllerEntity;
            this.targetEntity = targetEntity;
            this.radius = radius;
            this.interval = interval;
            this.tickCounter = 0;
            this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean m_8036_() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            return this.controllerEntity.m_6084_() && owner.m_6084_();
        }

        public void m_8037_() {
            if (this.tickCounter < this.interval) {
                ++this.tickCounter;
            }
            if (this.tickCounter >= this.interval) {
                LivingEntity owner = this.targetEntity.get();
                BlockPos controllerPos = owner.m_20183_();
                PedestalTile nearestPedestal = null;
                double minDistance = Double.MAX_VALUE;
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int y = -this.radius; y <= this.radius; ++y) {
                        for (int z = -this.radius; z <= this.radius; ++z) {
                            double distance;
                            PedestalTile pedestal;
                            BlockPos currentPos = controllerPos.m_7918_(x, y, z);
                            BlockState blockState = this.controllerEntity.m_9236_().m_8055_(currentPos);
                            if (!blockState.m_60713_((Block)BlockRegistry.PEDESTAL_BLOCK.get()) || (pedestal = (PedestalTile)this.controllerEntity.m_9236_().m_7702_(currentPos)) == null || pedestal.getHeldItem() == null || pedestal.getHeldItem().m_41619_() || !(pedestal.getHeldItem().m_41720_() instanceof Scroll) || !((distance = controllerPos.m_123331_((Vec3i)currentPos)) < minDistance)) continue;
                            minDistance = distance;
                            nearestPedestal = pedestal;
                        }
                    }
                }
                if (nearestPedestal != null) {
                    BlockState prevState = nearestPedestal.m_58900_();
                    ItemStack item = nearestPedestal.getHeldItem();
                    SpellData spellData = ISpellContainer.get((ItemStack)item).getSpellAtIndex(0);
                    ArchmagePetEntity.this.triggerAnim("interact_controller", "interact");
                    ItemStack finalItem = this.getResultSpell(spellData.getRarity());
                    SpellData spellDataFinal = ISpellContainer.get((ItemStack)finalItem).getSpellAtIndex(0);
                    nearestPedestal.setHeldItem(finalItem);
                    BlockState nextState = nearestPedestal.m_58900_();
                    ArchmagePetEntity.this.m_9236_().m_7260_(nearestPedestal.m_58899_(), prevState, nextState, 2);
                    float radius = 2.0f;
                    MagicManager.spawnParticles((Level)ArchmagePetEntity.this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(spellDataFinal.getSpell().getSchoolType().getTargetingColor(), radius), (double)nearestPedestal.m_58899_().m_252807_().f_82479_, (double)(nearestPedestal.m_58899_().m_252807_().f_82480_ + 1.0), (double)nearestPedestal.m_58899_().m_252807_().f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                    this.tickCounter = 0;
                }
            }
        }

        private ItemStack getResultSpell(SpellRarity rarity) {
            ItemStack resultStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            resultStack.m_41764_(1);
            List spells = SpellRegistry.getEnabledSpells();
            List<AbstractSpell> finalSpells = spells.stream().filter(spell -> spell.allowCrafting() || spell.allowLooting() || spell.equals(PetSpellRegistry.SUMMON_SHADOW.get())).toList();
            boolean spellSelected = false;
            Random random = new Random();
            int chance = random.nextInt(100);
            if (chance < 5 && rarity != SpellRarity.LEGENDARY) {
                int rarityValue = rarity.getValue() + 1;
                rarity = Arrays.stream(SpellRarity.values()).filter(rarityAux -> rarityAux.getValue() == rarityValue).findFirst().get();
            }
            while (!spellSelected) {
                Random spellRandom = new Random();
                int randomSpellIndex = spellRandom.nextInt(finalSpells.size());
                AbstractSpell spell2 = finalSpells.get(randomSpellIndex);
                if (spell2.getMaxRarity() < rarity.getValue() || spell2.getMinRarity() > rarity.getValue()) continue;
                ISpellContainer.createScrollContainer((AbstractSpell)spell2, (int)spell2.getMinLevelForRarity(rarity), (ItemStack)resultStack);
                spellSelected = true;
            }
            return resultStack;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

