/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.datagen.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemsModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemsModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemsModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ExtraCodecs.m_144637_((Codec)ForgeRegistries.ITEMS.getCodec().listOf()).fieldOf("item").forGetter(m -> m.items)).apply((Applicative)inst, AddItemsModifier::new)));
    public static final List<ResourceLocation> SNIFFERENT_ITEMS_LOC = List.of(AddItemsModifier.snifferentLoc("spindlefern_seeds"), AddItemsModifier.snifferentLoc("spineflower_seeds"), AddItemsModifier.snifferentLoc("lumibulb_seeds"), AddItemsModifier.snifferentLoc("sniffberry_seedling"), AddItemsModifier.snifferentLoc("bloom_plant_nut"), AddItemsModifier.snifferentLoc("globar_sapling"), AddItemsModifier.snifferentLoc("club_moss_patch"), AddItemsModifier.snifferentLoc("amber"));
    public static final List<ResourceLocation> HELLIONS_ITEMS_LOC = List.of(AddItemsModifier.hellionsLoc("stone_pine_sapling"), AddItemsModifier.hellionsLoc("fiddlefern"), AddItemsModifier.hellionsLoc("ivy"));
    public static final List<ResourceLocation> QUARK_ITEMS_LOC = List.of(new ResourceLocation("quark", "ancient_sapling"));
    private final List<Item> items;

    public AddItemsModifier(LootItemCondition[] conditionsIn, List<Item> items) {
        super(conditionsIn);
        this.items = items;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList newLoot = new ObjectArrayList();
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        generatedLoot.clear();
        generatedLoot.add((Object)Items.f_276594_.m_7968_());
        generatedLoot.add((Object)Items.f_271133_.m_7968_());
        this.modSupport(SNIFFERENT_ITEMS_LOC, generatedLoot);
        this.modSupport(HELLIONS_ITEMS_LOC, generatedLoot);
        this.modSupport(QUARK_ITEMS_LOC, generatedLoot);
        this.items.forEach(item -> generatedLoot.add((Object)item.m_7968_()));
        newLoot.add((Object)((ItemStack)Util.m_214621_(generatedLoot, (RandomSource)context.m_230907_())));
        return newLoot;
    }

    private void modSupport(List<ResourceLocation> itemsLocList, ObjectArrayList<ItemStack> generatedLoot) {
        ArrayList itemList = new ArrayList();
        itemsLocList.forEach(resourceLocation -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            if (item != null && !item.m_7968_().m_150930_(Items.f_41852_)) {
                itemList.add(item.m_7968_());
            }
        });
        if (itemList.isEmpty()) {
            return;
        }
        generatedLoot.addAll(itemList);
    }

    private static ResourceLocation snifferentLoc(String path) {
        return new ResourceLocation("snifferent", path);
    }

    private static ResourceLocation hellionsLoc(String path) {
        return new ResourceLocation("snifferplus", path);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

