/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block.entity;

import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import javax.annotation.Nonnull;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.alshanex.alshanex_familiars.util.rituals.RitualHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RitualCorePedestalEntity
extends BlockEntity {
    private static final String NBT_HELD_ITEM = "heldItem";
    private static final String NBT_ITEM_IN_RECIPE = "itemInRecipe";
    private static final String NBT_IS_VALID_RITUAL = "isValidRitual";
    private static final String NBT_COUNTER = "counter";
    private ItemStack heldItem = ItemStack.f_41583_;
    private boolean itemInRecipe = false;
    private boolean isValidRitual = false;
    private int counter = 0;

    public RitualCorePedestalEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.RITUAL_CORE.get(), pPos, pBlockState);
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack newItem) {
        this.heldItem = newItem;
        this.counter = 0;
        this.isValidRitual = false;
        this.itemInRecipe = false;
        if (!newItem.m_41619_() && RitualHelper.isItemInRecipeRecipe(this.f_58857_, newItem)) {
            this.itemInRecipe = true;
        }
        this.m_6596_();
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{this.heldItem});
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readNBT(nbt);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        this.writeNBT(tag);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNBT(tag);
        return tag;
    }

    public boolean m_7531_(int pId, int pType) {
        return super.m_7531_(pId, pType);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    private CompoundTag writeNBT(CompoundTag nbt) {
        if (!this.heldItem.m_41619_()) {
            nbt.m_128365_(NBT_HELD_ITEM, (Tag)this.heldItem.serializeNBT());
        } else {
            nbt.m_128365_(NBT_HELD_ITEM, (Tag)new CompoundTag());
        }
        nbt.m_128379_(NBT_ITEM_IN_RECIPE, this.itemInRecipe);
        nbt.m_128379_(NBT_IS_VALID_RITUAL, this.isValidRitual);
        nbt.m_128405_(NBT_COUNTER, this.counter);
        return nbt;
    }

    private CompoundTag readNBT(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_HELD_ITEM)) {
            this.heldItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_HELD_ITEM));
        }
        this.itemInRecipe = nbt.m_128471_(NBT_ITEM_IN_RECIPE);
        this.isValidRitual = nbt.m_128471_(NBT_IS_VALID_RITUAL);
        this.counter = nbt.m_128451_(NBT_COUNTER);
        return nbt;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (this.itemInRecipe && !this.heldItem.m_41619_()) {
            boolean wasValidRitual = this.isValidRitual;
            this.isValidRitual = RitualHelper.isValidRecipe(pLevel, pPos, this.getHeldItem());
            if (!wasValidRitual && this.isValidRitual) {
                AlshanexFamiliarsMod.LOGGER.debug("Ritual started for item: " + this.heldItem.m_41720_());
            }
        } else {
            this.isValidRitual = false;
            this.counter = 0;
        }
        if (this.isValidRitual) {
            if (this.counter < 100) {
                ParticleOptions particles;
                Item result;
                ++this.counter;
                if (this.counter % 10 == 0 && (result = RitualHelper.getResultForRecipe(pLevel, pPos, this.getHeldItem())) != null && (particles = RitualHelper.getParticleForRecipe(pLevel, pPos, this.getHeldItem())) != null) {
                    RitualHelper.spawnParticlesAtPedestals(particles, pPos, pLevel);
                }
            }
            if (this.counter >= 100) {
                this.completeRitual(pLevel, pPos, pState);
            }
        }
    }

    private void completeRitual(Level pLevel, BlockPos pPos, BlockState pState) {
        Item result = RitualHelper.getResultForRecipe(pLevel, pPos, this.getHeldItem());
        if (result != null) {
            MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 6.0f), (double)pPos.m_123341_(), (double)((float)pPos.m_123342_() + 0.165f), (double)pPos.m_123343_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            RitualHelper.clearItemsFromPedestals(pLevel, pPos);
            BlockState prevState = this.m_58900_();
            this.setHeldItem(new ItemStack((ItemLike)result));
            BlockState nextState = this.m_58900_();
            pLevel.m_7260_(pPos, prevState, nextState, 2);
            AlshanexFamiliarsMod.LOGGER.debug("Ritual completed! Result: " + result);
        }
        this.counter = 0;
        this.itemInRecipe = false;
        this.isValidRitual = false;
    }
}

