/*
 * Decompiled with CFR 0.152.
 */
package com.yoda.draconiccodex;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class DraconicCodexConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        COMMON = new Common(builder);
        COMMON_SPEC = builder.build();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue DragonforgedBookApplicationCost;
        public final ForgeConfigSpec.IntValue DragonforgedBookCreationCost;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ValidEnchantments;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("anvil cost");
            this.DragonforgedBookApplicationCost = builder.comment("Cost to apply a Dragonforged Codex to an item already at Max +1 (e.g. Quark Limit Breaker -> +2) {Default:50}").defineInRange("equipment_limit_decimator_cost", 50, 1, 1000);
            this.DragonforgedBookCreationCost = builder.comment("XP cost for powering up a Draconic Codex with an enchantment from an Ancient Tome {Default:30}").defineInRange("dragonforged_book_application_cost", 30, 1, 1000);
            builder.pop();
            builder.push("valid enchantments");
            this.ValidEnchantments = builder.comment("List of valid enchantments for the Draconic Codex. Paste from Quark or add your own.").defineListAllowEmpty("valid_enchantments", List.of("minecraft:feather_falling", "minecraft:thorns", "minecraft:sharpness", "minecraft:smite", "minecraft:bane_of_arthropods", "minecraft:knockback", "minecraft:fire_aspect", "minecraft:looting", "minecraft:sweeping", "minecraft:efficiency", "minecraft:unbreaking", "minecraft:fortune", "minecraft:power", "minecraft:punch", "minecraft:luck_of_the_sea", "minecraft:lure", "minecraft:loyalty", "minecraft:riptide", "minecraft:impaling", "minecraft:piercing"), obj -> obj instanceof String);
            builder.pop();
        }

        public List<ResourceLocation> validEnchantments() {
            return ((List)this.ValidEnchantments.get()).stream().map(Object::toString).map(ResourceLocation::m_135820_).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

