/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.util;

import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.fantasydice.FantasyDice;
import xyz.apex.forge.fantasydice.event.DiceRollEvent;
import xyz.apex.forge.fantasydice.init.DiceType;
import xyz.apex.forge.fantasydice.init.FTDiceTypes;
import xyz.apex.forge.fantasydice.item.DiceItem;

public class DiceHelper {
    @Nullable
    private static MutableComponent apexNameComponent = null;

    public static int roll(RandomSource rng, int min, int max, int dieQuality, boolean isApex) {
        int roll;
        int newMax;
        if (max < min) {
            int tmp = max;
            max = min;
            min = tmp;
        }
        int maxOriginal = max;
        int minOriginal = min;
        if (dieQuality > 0) {
            newMax = rng.m_188503_(dieQuality);
            if (newMax != 0) {
                max += newMax;
            }
        } else if (dieQuality < 0 && (newMax = rng.m_188503_(Math.abs(dieQuality))) != 0) {
            max -= newMax;
        }
        if (!isApex) {
            min = Math.max(min, minOriginal);
        }
        if ((roll = rng.m_188503_(max = Math.min(max, maxOriginal)) + 1) < min) {
            while (roll < min) {
                roll = rng.m_188503_(max) + 1;
            }
        }
        return roll;
    }

    public static boolean throwDice(Level level, Player player, InteractionHand hand, ItemStack stack, int min) {
        if (stack.m_41619_()) {
            return false;
        }
        if (level.f_46443_) {
            return true;
        }
        DiceItem die = (DiceItem)stack.m_41720_();
        int sides = die.getSides();
        int stackCount = stack.m_41613_();
        int maxPossibleRoll = sides * stackCount;
        DiceType<DiceItem, DiceItem> diceType = die.getDiceType();
        boolean isApex = diceType.matches(FTDiceTypes.DICE_APEX);
        int[] rolls = IntStream.range(0, stackCount).map(i -> DiceHelper.rollDice(level, player, hand, stack, min)).toArray();
        int roll = Arrays.stream(rolls).sum();
        if (!isApex) {
            roll = Mth.m_14045_((int)roll, (int)min, (int)maxPossibleRoll);
        }
        DiceRollEvent.fireDiceRoll(player, hand, stack, diceType, roll, rolls, maxPossibleRoll);
        MutableComponent textComponent = DiceHelper.createTextComponent(player, stack, die, roll, sides, rolls);
        DiceHelper.sendMessageToPlayers(player, (Component)textComponent);
        return true;
    }

    private static int rollDice(Level level, Player player, InteractionHand hand, ItemStack stack, int min) {
        DiceItem die = (DiceItem)stack.m_41720_();
        int sides = die.getSides();
        DiceType<DiceItem, DiceItem> diceType = die.getDiceType();
        int diceQuality = diceType.getDiceQuality();
        boolean isApex = diceType.matches(FTDiceTypes.DICE_APEX);
        int roll = DiceHelper.roll(level.f_46441_, min, sides, diceQuality, isApex);
        roll = diceType.onRoll(player, hand, stack, min, sides, roll);
        if (!isApex) {
            roll = Mth.m_14045_((int)roll, (int)min, (int)sides);
        }
        return roll;
    }

    private static MutableComponent createTextComponent(Player player, ItemStack stack, DiceItem die, int roll, int sides, @Nullable int[] rolls) {
        DiceType<?, ?> diceType = die.getDiceType();
        Component[] rollsComponent = new Component[]{Component.m_237119_()};
        if (rolls != null && rolls.length > 1) {
            rollsComponent[0] = Component.m_237113_((String)"\n%s".formatted(Arrays.toString(rolls))).m_130938_(s -> s.m_131155_(Boolean.valueOf(true)));
        }
        return Component.m_237110_((String)"fantasydice.die.roll", (Object[])new Object[]{player.m_5446_(), Component.m_237110_((String)"fantasydice.die.roll.result", (Object[])new Object[]{roll, stack.m_41613_(), sides}).m_130938_(style -> diceType.withStyle(stack, (Style)style))}).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)stack.m_41786_().m_6881_().m_7220_(rollsComponent[0]).m_130938_(hoverStyle -> diceType.withStyle(stack, (Style)hoverStyle)))));
    }

    public static void sendMessageToPlayers(Player player, Component component) {
        MinecraftServer server = player.m_20194_();
        UUID playerID = player.m_36316_().getId();
        player.m_5661_(component, false);
        if (server == null) {
            return;
        }
        DimensionType dimensionType = player.m_9236_().m_6042_();
        ChunkPos chunkPos = new ChunkPos(player.m_20183_());
        for (ServerPlayer plr : server.m_6846_().m_11314_()) {
            if (plr.m_36316_().getId().equals(playerID) || (dimensionType == plr.m_9236_().m_6042_() ? chunkPos.m_45594_(new ChunkPos(plr.m_20183_())) > (Integer)FantasyDice.CONFIG.diceRollMessageRange.get() : (Boolean)FantasyDice.CONFIG.diceRollMessageCrossDimensions.get() == false)) continue;
            plr.m_5661_(component, false);
        }
    }

    public static boolean isLuckyRoller(Player player) {
        UUID playerId = player.m_36316_().getId();
        if (playerId.equals(FantasyDice.FANTASY_UUID)) {
            return true;
        }
        return FantasyDice.CONFIG.luckyRollerIDs.contains(playerId);
    }

    public static MutableComponent makeApexComponent(Random rng, Component component) {
        if (apexNameComponent != null) {
            return apexNameComponent;
        }
        MutableComponent apex = Component.m_237119_().m_6879_();
        String string = component.getString();
        for (char c : string.toCharArray()) {
            boolean obfuscate = rng.nextBoolean();
            apex = apex.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_130938_(style -> style.m_178524_(Boolean.valueOf(obfuscate))));
        }
        if (FantasyDice.loadComplete && apexNameComponent == null) {
            apexNameComponent = apex;
        }
        return apex;
    }
}

