/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.item;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.fantasydice.FantasyDice;
import xyz.apex.forge.fantasydice.init.DiceType;
import xyz.apex.forge.fantasydice.init.FTDiceTypes;
import xyz.apex.forge.fantasydice.util.DiceHelper;

public class DiceItem
extends Item {
    private static final Random RNG = new Random();
    private final int sides;
    @Nullable
    private DiceType<?, ?> diceType;

    public DiceItem(Item.Properties properties, int sides) {
        super(properties);
        this.sides = sides;
    }

    public DiceType<?, ?> getDiceType() {
        return Objects.requireNonNull(this.diceType);
    }

    public void setDiceType(DiceType<?, ?> diceType) {
        if (this.diceType == null) {
            this.diceType = diceType;
        }
    }

    public int getSides() {
        return this.sides;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Integer cooldown = (Integer)FantasyDice.CONFIG.diceCooldown.get();
        if (cooldown > 0) {
            player.m_36335_().m_41524_((Item)this, cooldown.intValue());
        }
        if (DiceHelper.throwDice(level, player, hand, stack, 1)) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public Component m_41466_() {
        return this.buildNameComponent(ItemStack.f_41583_);
    }

    public Component m_7626_(ItemStack stack) {
        return this.buildNameComponent(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.diceType != null && this.diceType.usesFoil() || super.m_5812_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.diceType != null) {
            tooltip.add((Component)this.diceType.getType().getComponent(stack, this.diceType));
        }
    }

    private Component buildNameComponent(ItemStack stack) {
        MutableComponent nameComponent = Component.m_237115_((String)this.m_5524_());
        if (this.diceType != null && this.diceType.matches(FTDiceTypes.DICE_APEX)) {
            nameComponent = DiceHelper.makeApexComponent(RNG, (Component)nameComponent);
        }
        return nameComponent.m_130938_(style -> this.withStyle(stack, (Style)style));
    }

    private Style withStyle(ItemStack stack, Style style) {
        return this.diceType == null ? style : this.diceType.withStyle(stack, style);
    }
}

