/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.item;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.fantasydice.FantasyDice;
import xyz.apex.forge.fantasydice.init.FTDiceTypes;
import xyz.apex.forge.fantasydice.init.FTItems;
import xyz.apex.forge.fantasydice.util.DiceHelper;

public class CoinItem
extends Item {
    public static final int HEADS = 1;
    public static final int TAILS = 2;

    public CoinItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Integer cooldown = (Integer)FantasyDice.CONFIG.diceCooldown.get();
        if (cooldown > 0) {
            player.m_36335_().m_41524_((Item)this, cooldown.intValue());
        }
        if (CoinItem.flip(level, player, hand, stack, style -> this.withStyle(stack, (Style)style))) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"fantasydicecoin.desc").m_130938_(style -> this.withStyle(stack, (Style)style).m_131155_(Boolean.valueOf(true))));
    }

    public Component m_41466_() {
        return this.buildNameComponent(ItemStack.f_41583_);
    }

    public Component m_7626_(ItemStack stack) {
        return this.buildNameComponent(stack);
    }

    private MutableComponent buildNameComponent(ItemStack stack) {
        return Component.m_237115_((String)this.m_5524_()).m_130938_(style -> this.withStyle(stack, (Style)style));
    }

    private Style withStyle(ItemStack stack, Style style) {
        if (FTItems.IRON_COIN.is((Item)this)) {
            return FTDiceTypes.DICE_IRON.withStyle(stack, style);
        }
        if (FTItems.GOLDEN_COIN.is((Item)this)) {
            return FTDiceTypes.DICE_GOLD.withStyle(stack, style);
        }
        return style;
    }

    public static boolean flip(Level level, Player player, InteractionHand hand, ItemStack stack, UnaryOperator<Style> withStyle) {
        if (stack.m_41619_()) {
            return false;
        }
        if (level.f_46443_) {
            return true;
        }
        int heads = 0;
        int tails = 0;
        for (int i = 0; i < stack.m_41613_(); ++i) {
            int roll = DiceHelper.roll(level.f_46441_, 1, 2, 0, false);
            if (roll == 1) {
                ++heads;
                continue;
            }
            if (roll == 2) {
                ++tails;
                continue;
            }
            throw new RuntimeException("Invalid coin flip state");
        }
        MutableComponent message = CoinItem.buildFlipMessage(player, stack, heads, tails, withStyle);
        DiceHelper.sendMessageToPlayers(player, (Component)message);
        return true;
    }

    public static MutableComponent buildFlipMessage(Player player, ItemStack stack, int heads, int tails, UnaryOperator<Style> withStyle) {
        MutableComponent prefix = Component.m_237110_((String)"fantasydice.coin.flip.prefix", (Object[])new Object[]{player.m_5446_()});
        MutableComponent suffix = Component.m_237110_((String)"fantasydice.coin.flip.suffix", (Object[])new Object[]{heads, tails}).m_130938_(style -> ((Style)withStyle.apply((Style)style)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)stack.m_41786_())));
        return prefix.m_130946_(" ").m_7220_((Component)suffix);
    }
}

