/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.init;

import com.google.common.collect.Lists;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.apexcore.registrate.CoreRegistrate;
import xyz.apex.forge.apexcore.registrate.builder.ItemBuilder;
import xyz.apex.forge.apexcore.registrate.entry.ItemEntry;
import xyz.apex.forge.apexcore.registrate.holder.ItemHolder;
import xyz.apex.forge.commonality.tags.ItemTags;
import xyz.apex.forge.fantasydice.init.FTTags;
import xyz.apex.forge.fantasydice.item.DiceItem;

public final class DiceType<OWNER extends CoreRegistrate<OWNER>, DIE extends DiceItem> {
    private static final List<DiceType<?, ?>> diceTypes = Lists.newArrayList();
    private final String name;
    private final OWNER owner;
    private final Int2ObjectMap<ItemEntry<DIE>> diceItems = new Int2ObjectOpenHashMap();
    private final TagKey<Item> tag;
    private final BiFunction<ItemStack, Style, Style> styleModifier;
    private final IntSupplier diceQuality;
    private final RollCallback rollCallback;
    private final boolean usesFoil;
    private final Type type;

    private DiceType(Builder<OWNER, DIE> builder) {
        this.name = (String)Validate.notBlank((CharSequence)builder.name);
        this.owner = builder.owner;
        this.tag = builder.tag;
        this.styleModifier = builder.styleModifier;
        this.rollCallback = builder.rollCallback;
        this.usesFoil = builder.usesFoil;
        this.diceQuality = builder.diceQuality;
        this.type = builder.type;
        for (Int2ObjectMap.Entry entry : builder.dieNames.int2ObjectEntrySet()) {
            int sides = entry.getIntKey();
            String dieName = (String)entry.getValue();
            RegistryEntry registryEntry = this.owner.get(dieName, Registries.f_256913_);
            ItemEntry itemEntry = ItemEntry.cast((RegistryEntry)registryEntry);
            this.diceItems.put(sides, (Object)itemEntry);
        }
        diceTypes.add(this);
        this.owner.addRegisterCallback(Registries.f_256913_, () -> this.diceItems.values().stream().map(RegistryEntry::get).forEach(i -> i.setDiceType(this)));
    }

    public boolean matches(DiceType<?, ?> other) {
        return this.owner.getModId().equals(other.owner.getModId()) && this.name.equals(other.name);
    }

    public OWNER getOwner() {
        return this.owner;
    }

    public Style withStyle(ItemStack stack, Style style) {
        return this.styleModifier.apply(stack, style);
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public ItemEntry<DIE> getItem(int sides) {
        if (this.diceItems.containsKey(sides)) {
            return (ItemEntry)this.diceItems.get(sides);
        }
        throw new NullPointerException("Unknown Die side count: " + sides);
    }

    public Type getType() {
        return this.type;
    }

    public ObjectCollection<ItemEntry<DIE>> getItems() {
        return this.diceItems.values();
    }

    public int getDiceQuality() {
        return this.diceQuality.getAsInt();
    }

    public IntSet getValidSides() {
        return this.diceItems.keySet();
    }

    public String getName() {
        return this.name;
    }

    public boolean usesFoil() {
        return this.usesFoil;
    }

    public int onRoll(Player player, InteractionHand hand, ItemStack stack, int min, int sides, int roll) {
        int diceQuality = this.diceQuality.getAsInt();
        return this.rollCallback.onRoll(player, hand, stack, min, sides, roll, diceQuality);
    }

    public static <OWNER extends CoreRegistrate<OWNER>, DIE extends DiceItem> Builder<OWNER, DIE> builder(String name, OWNER owner, BiFunction<Item.Properties, Integer, DIE> diceFactory) {
        return new Builder<OWNER, DIE>(name, owner, diceFactory);
    }

    public static <OWNER extends CoreRegistrate<OWNER>> Builder<OWNER, DiceItem> builder(String name, OWNER owner) {
        return DiceType.builder(name, owner, DiceItem::new);
    }

    public static List<DiceType<?, ?>> getDiceTypes() {
        return diceTypes;
    }

    public static final class Builder<OWNER extends CoreRegistrate<OWNER>, DIE extends DiceItem> {
        private final String name;
        private final OWNER owner;
        private final TagKey<Item> tag;
        private final Int2ObjectMap<String> dieNames = new Int2ObjectOpenHashMap();
        private final BiFunction<Item.Properties, Integer, DIE> diceFactory;
        private Type type = Type.REGULAR;
        private IntSupplier diceQuality = () -> 0;
        private BiFunction<ItemStack, Style, Style> styleModifier = (stack, style) -> style;
        private RollCallback rollCallback = (player, hand, stack, min, sides, rolls, dieQuality) -> rolls;
        private boolean usesFoil = false;

        private Builder(String name, OWNER owner, BiFunction<Item.Properties, Integer, DIE> diceFactory) {
            this.name = name;
            this.owner = owner;
            this.diceFactory = diceFactory;
            this.tag = ItemTags.tag((String)owner.getModId(), (String)("dice/" + name));
            owner.addDataGenerator(ProviderType.ITEM_TAGS, provider -> provider.addTag(FTTags.Items.DICE).m_206428_(this.tag));
        }

        public Builder<OWNER, DIE> withType(Type type) {
            this.type = type;
            return this;
        }

        public Builder<OWNER, DIE> withDiceQuality(IntSupplier diceQuality) {
            this.diceQuality = diceQuality;
            return this;
        }

        public Builder<OWNER, DIE> withStyle(BiFunction<ItemStack, Style, Style> nameStyle) {
            this.styleModifier = nameStyle;
            return this;
        }

        public Builder<OWNER, DIE> onRoll(RollCallback rollCallback) {
            this.rollCallback = rollCallback;
            return this;
        }

        public ItemBuilder<OWNER, DIE, Builder<OWNER, DIE>> withDie(int sides) {
            return ((ItemHolder)this.owner.object(this.generateDieName(sides))).item((Object)this, properties -> (DiceItem)((Object)((Object)this.diceFactory.apply(properties, sides)))).tag(new TagKey[]{this.tag}).lang("%d-Sided %s Die".formatted(sides, RegistrateLangProvider.toEnglishName((String)this.name))).stacksTo(8).model((ctx, provider) -> provider.generated((NonNullSupplier)ctx, new ResourceLocation[]{new ResourceLocation("fantasydice", "item/die/%s/%d_sided".formatted(this.name, sides))}));
        }

        public Builder<OWNER, DIE> withSimpleDie(int sides) {
            return (Builder)this.withDie(sides).build();
        }

        public Builder<OWNER, DIE> usesFoil() {
            this.usesFoil = true;
            return this;
        }

        public DiceType<OWNER, DIE> build() {
            return new DiceType(this);
        }

        private String generateDieName(int sides) {
            return (String)this.dieNames.computeIfAbsent(sides, $ -> $ + "_sided_" + this.name + "_die");
        }
    }

    @FunctionalInterface
    public static interface RollCallback {
        public int onRoll(Player var1, InteractionHand var2, ItemStack var3, int var4, int var5, int var6, int var7);
    }

    public static enum Type {
        REGULAR("fantasydice", "regular"),
        COSMETIC("fantasydice", "cosmetic"),
        SPECIALITY("fantasydice", "specialty");

        public static final Type[] VALUES;
        private final String translationKey;

        private Type(String modId, String name) {
            this(String.format("%s.die.type.%s.name", modId, name));
        }

        private Type(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public MutableComponent getComponent(ItemStack stack, DiceType<?, ?> diceType) {
            int diceQuality = diceType.getDiceQuality();
            return Component.m_237115_((String)this.translationKey).m_130946_(diceQuality > 0 ? " (+%d)".formatted(diceQuality) : " (%d)".formatted(diceQuality)).m_130938_(style -> diceType.withStyle(stack, (Style)style).m_131155_(Boolean.valueOf(true)));
        }

        static {
            VALUES = Type.values();
        }
    }
}

