/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.event;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import xyz.apex.forge.fantasydice.init.DiceType;

public final class DiceRollEvent
extends PlayerEvent {
    private final InteractionHand hand;
    private final ItemStack stack;
    private final DiceType<?, ?> diceType;
    private final int roll;
    private final IntList rolls;
    private final int maxPossibleRoll;

    DiceRollEvent(Player player, InteractionHand hand, ItemStack stack, DiceType<?, ?> diceType, int roll, IntList rolls, int maxPossibleRoll) {
        super(player);
        this.hand = hand;
        this.stack = stack;
        this.diceType = diceType;
        this.roll = roll;
        this.rolls = rolls;
        this.maxPossibleRoll = maxPossibleRoll;
    }

    public InteractionHand hand() {
        return this.hand;
    }

    public ItemStack diceStack() {
        return this.stack;
    }

    public DiceType<?, ?> diceType() {
        return this.diceType;
    }

    public int roll() {
        return this.roll;
    }

    public IntList rolls() {
        return this.rolls;
    }

    public int maxPossibleRoll() {
        return this.maxPossibleRoll;
    }

    public static void fireDiceRoll(Player player, InteractionHand hand, ItemStack stack, DiceType<?, ?> diceType, int roll, int[] rolls, int maxPossibleRoll) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new DiceRollEvent(player, hand, stack, diceType, roll, IntList.of((int[])rolls), maxPossibleRoll));
    }
}

