/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.container.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemInventory
extends SimpleContainer {
    public static final String NBT_INVENTORY = "Inventory";
    public static final String NBT_ITEMS = "Items";
    public static final String NBT_SLOTS = "Slots";
    private final ItemStack item;
    private int openCount = 0;

    public ItemInventory(ItemStack item, int slots) {
        super(slots);
        this.item = item;
    }

    public void m_5856_(Player player) {
        if (this.openCount == 0) {
            ItemInventory.load(this);
        }
        ++this.openCount;
    }

    public void m_5785_(Player player) {
        --this.openCount;
        if (this.openCount == 0) {
            ItemInventory.save(this);
        }
    }

    public ItemStack getContainerItem() {
        return this.item;
    }

    public static void save(ItemInventory inventory) {
        CompoundTag invTag = new CompoundTag();
        ListTag slotTag = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_(NBT_SLOTS, (byte)i);
            stack.m_41739_(itemTag);
            slotTag.add((Object)itemTag);
        }
        invTag.m_128365_(NBT_ITEMS, (Tag)slotTag);
        inventory.item.m_41700_(NBT_INVENTORY, (Tag)invTag);
    }

    public static void load(ItemInventory inventory) {
        CompoundTag invTag = inventory.item.m_41737_(NBT_INVENTORY);
        if (invTag != null) {
            ListTag slotTag = invTag.m_128437_(NBT_ITEMS, 10);
            for (int i = 0; i < slotTag.size(); ++i) {
                CompoundTag itemTag = slotTag.m_128728_(i);
                int slotIndex = itemTag.m_128445_(NBT_SLOTS) & 0xFF;
                if (slotIndex >= inventory.m_6643_()) continue;
                inventory.m_6836_(slotIndex, ItemStack.m_41712_((CompoundTag)itemTag));
            }
        }
    }
}

