/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.container;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.container.BaseMenu;
import xyz.apex.forge.fantasydice.container.inventory.ItemInventory;
import xyz.apex.forge.fantasydice.init.FTItems;
import xyz.apex.forge.fantasydice.init.FTTags;

public final class PouchContainer
extends BaseMenu {
    private final InteractionHand hand;
    private final ItemStack stack;
    private final IItemHandler itemHandler;
    private final ItemInventory inventory;

    public PouchContainer(@Nullable MenuType<? extends PouchContainer> containerType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(containerType, windowId, playerInventory, buffer);
        this.hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        this.stack = playerInventory.f_35978_.m_21120_(this.hand);
        this.inventory = new ItemInventory(this.stack, 18);
        this.inventory.m_5856_(this.player);
        this.itemHandler = new InvWrapper((Container)this.inventory);
        PouchContainer.bindItemHandlerSlots((BaseMenu)this, (IItemHandler)this.itemHandler, (int)3, (int)6, (int)35, (int)17, DiceSlot::new);
        PouchContainer.bindPlayerInventory((BaseMenu)this, PouchSlot::new);
    }

    public boolean m_6875_(Player player) {
        return super.m_6875_(player) && this.inventory.m_6542_(player);
    }

    protected IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void onInventoryChanges() {
        this.inventory.m_6596_();
    }

    public void m_6877_(Player player) {
        this.inventory.m_6596_();
        super.m_6877_(player);
        this.inventory.m_5785_(this.player);
    }

    public static final class PouchSlot
    extends Slot {
        public PouchSlot(Container container, int slotIndex, int x, int y) {
            super(container, slotIndex, x, y);
        }

        public boolean m_8010_(Player player) {
            return !FTItems.POUCH.isIn(this.m_7993_());
        }
    }

    public static final class DiceSlot
    extends SlotItemHandler {
        public DiceSlot(IItemHandler itemHandler, int slotIndex, int x, int y) {
            super(itemHandler, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(FTTags.Items.DICE);
        }
    }
}

