/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.container;

import com.google.common.util.concurrent.Runnables;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.container.BaseMenu;
import xyz.apex.forge.fantasydice.init.FTBlocks;
import xyz.apex.forge.fantasydice.init.FTRecipes;
import xyz.apex.forge.fantasydice.item.crafting.DiceStationRecipe;

public final class DiceStationMenu
extends BaseMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<DiceStationRecipe> recipes = Collections.emptyList();
    private ItemStack input = ItemStack.f_41583_;
    private long lastSoundTime;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private Runnable slotUpdateListener = Runnables.doNothing();
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            DiceStationMenu.this.m_6199_((Container)this);
            DiceStationMenu.this.slotUpdateListener.run();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();

    public DiceStationMenu(@Nullable MenuType<? extends DiceStationMenu> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, playerInventory, buffer);
        this.access = buffer.readBoolean() ? ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)this.pos) : ContainerLevelAccess.f_39287_;
        this.level = playerInventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(DiceStationMenu.this.level, player, stack.m_41613_());
                DiceStationMenu.this.resultContainer.m_58395_(player, List.of(DiceStationMenu.this.inputSlot.m_7993_()));
                ItemStack input = DiceStationMenu.this.inputSlot.m_6201_(1);
                if (!input.m_41619_()) {
                    DiceStationMenu.this.setupResultSlot();
                }
                DiceStationMenu.this.access.m_39292_((world, pos) -> {
                    long l = world.m_46467_();
                    if (DiceStationMenu.this.lastSoundTime != l) {
                        world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        DiceStationMenu.this.lastSoundTime = l;
                    }
                });
            }
        });
        DiceStationMenu.bindPlayerInventory((BaseMenu)this, (int)8, (int)84);
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<DiceStationRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    private void setupRecipeList(Container inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)FTRecipes.DICE_STATION_RECIPE_TYPE.get(), inventory, this.level);
        }
    }

    private void setupResultSlot() {
        int recipeIndex = this.selectedRecipeIndex.m_6501_();
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(recipeIndex)) {
            DiceStationRecipe recipe = this.recipes.get(recipeIndex);
            this.resultContainer.m_6029_((Recipe)recipe);
            this.resultSlot.m_5852_(recipe.m_5874_(this.container, this.level.m_9598_()));
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
    }

    public void registerUpdateListener(Runnable slotUpdateListener) {
        this.slotUpdateListener = slotUpdateListener;
    }

    public boolean m_6875_(Player player) {
        return super.m_6875_(player) && DiceStationMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FTBlocks.DICE_STATION.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    public void m_6199_(Container inventory) {
        ItemStack stack = this.inputSlot.m_7993_();
        if (stack.m_41720_() != this.input.m_41720_()) {
            this.input = stack.m_41777_();
            this.setupRecipeList(inventory, stack);
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            Item item = stack1.m_41720_();
            stack = stack1.m_41777_();
            if (slotIndex == 1) {
                item.m_7836_(stack1, this.level, player);
                if (!this.m_38903_(stack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack1, stack);
            } else if (slotIndex == 0 ? !this.m_38903_(stack1, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)FTRecipes.DICE_STATION_RECIPE_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{stack1}), this.level).isPresent() ? !this.m_38903_(stack1, 0, 1, false) : (slotIndex >= 2 && slotIndex < 29 ? !this.m_38903_(stack1, 29, 38, false) : slotIndex >= 29 && slotIndex < 38 && !this.m_38903_(stack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack1);
            this.m_38946_();
        }
        return stack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((world, pos) -> this.m_150411_(player, this.container));
    }
}

