/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasydice.client.screen;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import xyz.apex.forge.commonality.SideOnly;
import xyz.apex.forge.fantasydice.container.DiceStationMenu;
import xyz.apex.forge.fantasydice.item.crafting.DiceStationRecipe;

@SideOnly(value=SideOnly.Side.CLIENT)
public class DiceStationMenuScreen
extends AbstractContainerScreen<DiceStationMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("fantasydice", "textures/gui/container/dice_station.png");
    private float scrollOffset = 0.0f;
    private boolean scrolling = false;
    private int startIndex = 0;
    private boolean displayRecipes = false;

    public DiceStationMenuScreen(DiceStationMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        container.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((DiceStationMenu)this.f_97732_).getNumRecipes() > 12;
    }

    private int getOffscreenRows() {
        return (((DiceStationMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((DiceStationMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffset = 0.0f;
            this.startIndex = 0;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        graphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffset);
        graphics.m_280218_(TEXTURE, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(graphics, mouseX, mouseY, l, i1, j1);
        this.renderRecipes(graphics, l, i1, j1);
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        super.m_280072_(graphics, x, y);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<DiceStationRecipe> recipes = ((DiceStationMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < recipes.size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                graphics.m_280153_(this.f_96547_, recipes.get(l).m_8043_(this.f_96541_.f_91073_.m_9598_()), x, y);
            }
        }
    }

    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int lastVisibleElementIndex) {
        for (int i = this.startIndex; i < lastVisibleElementIndex && i < ((DiceStationMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((DiceStationMenu)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            graphics.m_280218_(TEXTURE, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int left, int top, int recipeIndexOffsetMax) {
        List<DiceStationRecipe> recipes = ((DiceStationMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < recipeIndexOffsetMax && i < ((DiceStationMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            ItemStack resultItem = recipes.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_());
            graphics.m_280203_(resultItem, k, i1);
            graphics.m_280370_(this.f_96547_, resultItem, k, i1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((DiceStationMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((DiceStationMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if ((double)mouseButton >= (double)i && mouseX < (double)i + 12.0 && mouseY >= (double)j && mouseY < (double)j + 54.0) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffset = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)i);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)i) + 0.5) * 4;
        }
        return true;
    }
}

