/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class MidiConverter {
    private static final String URL = "https://api.conczin.net/v1/convert/";

    public static Response request(byte[] body) {
        return MidiConverter.request(body, "midi", Map.of("from_format", "abc"));
    }

    public static Response request(byte[] body, String toFormat, Map<String, String> queryParams) {
        try {
            Object fullUrl = URL + toFormat;
            if (queryParams != null) {
                fullUrl = queryParams.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)queryParams.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", (String)fullUrl + "?", ""));
            }
            HttpURLConnection con = (HttpURLConnection)new URL((String)fullUrl).openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/octet-stream");
            con.setRequestProperty("Accept", "application/octet-stream");
            OutputStream outputStream = con.getOutputStream();
            outputStream.write(body);
            outputStream.flush();
            int responseCode = con.getResponseCode();
            String error = null;
            if (con.getErrorStream() != null) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                error = response.toString();
            }
            byte[] bytes = con.getInputStream().readAllBytes();
            return new Response(responseCode, error, bytes);
        }
        catch (Exception e) {
            return new Response(400, e.toString());
        }
    }

    public static class Response {
        int responseCode;
        @Nullable
        String error;
        byte[] body;

        public Response(int responseCode, @Nullable String error, byte[] body) {
            this.responseCode = responseCode;
            this.error = error;
            this.body = body;
        }

        public Response(int responseCode, @Nullable String error) {
            this(responseCode, error, new byte[0]);
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        @Nullable
        public String getError() {
            return this.error;
        }

        public byte[] getBody() {
            return this.body;
        }

        public String toString() {
            return "Response{responseCode=" + this.responseCode + ", error='" + this.error + "', body length=" + this.body.length + "}";
        }
    }
}

