/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.unlocking;

import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.content.monobank.unlocking.Combination;
import io.github.mortuusars.monobank.core.inventory.UnlockingSlot;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class UnlockingMenu
extends AbstractContainerMenu {
    public final MonobankBlockEntity monobankEntity;
    public final Combination combination;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public UnlockingMenu(int containerID, Inventory playerInventory, MonobankBlockEntity monobankEntity, Combination combination) {
        super((MenuType)Registry.MenuTypes.MONOBANK_UNLOCKING.get(), containerID);
        this.monobankEntity = monobankEntity;
        this.combination = combination;
        this.level = playerInventory.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)monobankEntity.m_58904_(), (BlockPos)monobankEntity.m_58899_());
        IItemHandler unlockingInventoryHandler = monobankEntity.getUnlockingInventoryHandler();
        this.m_38897_((Slot)new UnlockingSlot(unlockingInventoryHandler, 0, 80, 35, new ItemStack((ItemLike)combination.getItemInSlot(0))));
        this.m_38897_((Slot)new UnlockingSlot(unlockingInventoryHandler, 1, 101, 35, new ItemStack((ItemLike)combination.getItemInSlot(1))));
        this.m_38897_((Slot)new UnlockingSlot(unlockingInventoryHandler, 2, 122, 35, new ItemStack((ItemLike)combination.getItemInSlot(2))));
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, 8 + column * 18, 142));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        if (!this.level.f_46443_ && monobankEntity.getLock().getCombination().isEmpty()) {
            monobankEntity.startUnlocking();
        }
    }

    public static UnlockingMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new UnlockingMenu(containerID, playerInventory, UnlockingMenu.getBlockEntity(playerInventory, buffer), Combination.fromBuffer(buffer));
    }

    public ItemStack m_7648_(Player player, int index) {
        block3: {
            ItemStack clickedSlotStack;
            block2: {
                Slot clickedSlot = (Slot)this.f_38839_.get(index);
                if (clickedSlot == null || !clickedSlot.m_6657_()) {
                    return ItemStack.f_41583_;
                }
                clickedSlotStack = clickedSlot.m_7993_();
                if (index >= 3) break block2;
                ItemStack removedStack = clickedSlot.m_6201_(clickedSlotStack.m_41613_());
                this.m_38903_(removedStack, 3, this.f_38839_.size(), false);
                if (removedStack.m_41619_()) break block3;
                clickedSlot.m_150659_(removedStack);
                break block3;
            }
            for (int i = 0; i < 3; ++i) {
                UnlockingSlot unlockingSlot;
                Object object = this.f_38839_.get(i);
                if (!(object instanceof UnlockingSlot) || (unlockingSlot = (UnlockingSlot)((Object)object)).m_6657_() || !ItemStack.m_41656_((ItemStack)unlockingSlot.getKeyway(), (ItemStack)clickedSlotStack) || !unlockingSlot.m_5857_(clickedSlotStack)) continue;
                unlockingSlot.m_150659_(clickedSlotStack.m_41620_(1));
                break;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player player) {
        if (!player.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                IItemHandler unlockingInventory = this.monobankEntity.getUnlockingInventoryHandler();
                if (unlockingInventory.getStackInSlot(i).m_41619_()) continue;
                ItemStack itemStack = unlockingInventory.extractItem(i, 1, false);
                player.m_36176_(itemStack, false);
            }
        }
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        return this.monobankEntity.getLock().isLocked() && !this.monobankEntity.isUnlocking() && UnlockingMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)player, (Block)((Block)Registry.Blocks.MONOBANK.get()));
    }

    private static MonobankBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntityAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntityAtPos instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankBlockEntity = (MonobankBlockEntity)blockEntityAtPos;
            return monobankBlockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntityAtPos);
    }
}

