/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.unlocking;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class Combination {
    public static final int SIZE = 3;
    private final List<Item> combination;

    public Combination(List<Item> combination) {
        Preconditions.checkArgument((combination.size() == 3 ? 1 : 0) != 0, (Object)("Combination should have 3 items. Provided " + combination.size() + "."));
        this.combination = new ArrayList<Item>(combination);
    }

    public static Combination empty() {
        return new Combination(List.of(Items.f_41852_, Items.f_41852_, Items.f_41852_));
    }

    public boolean isEmpty() {
        return this.combination.stream().allMatch(item -> item == Items.f_41852_);
    }

    public Item getItemInSlot(int slot) {
        Preconditions.checkState((slot >= 0 && slot < 3 ? 1 : 0) != 0, (Object)"Slot is out of bounds.");
        return this.combination.get(slot);
    }

    public boolean matches(List<Item> sequence) {
        if (sequence.size() < 3) {
            return false;
        }
        for (int i = 0; i < this.combination.size(); ++i) {
            if (this.matches(i, sequence.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matches(int slot, Item key) {
        if (slot < 0 || slot >= this.combination.size()) {
            return false;
        }
        return ForgeRegistries.ITEMS.getKey((Object)this.combination.get(slot)).equals((Object)ForgeRegistries.ITEMS.getKey((Object)key));
    }

    public int findMatchingSlot(Item key) {
        for (int i = 0; i < this.combination.size(); ++i) {
            if (!this.matches(i, key)) continue;
            return i;
        }
        return -1;
    }

    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        for (int i = 0; i < this.combination.size(); ++i) {
            StringTag stringTag = StringTag.m_129297_((String)ForgeRegistries.ITEMS.getKey((Object)this.combination.get(i)).toString());
            list.add((Object)stringTag);
        }
        return list;
    }

    public void deserializeNBT(ListTag listTag) {
        int i;
        int listTagSize = listTag.size();
        for (i = 0; i < listTagSize; ++i) {
            String itemRegistryName = listTag.m_128778_(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemRegistryName));
            this.combination.set(i, item != null ? item : Items.f_41852_);
        }
        if (listTagSize < 3) {
            for (i = listTagSize; i < 3 - listTagSize; ++i) {
                this.combination.set(i, Items.f_41852_);
            }
        }
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.combination.size());
        for (int i = 0; i < this.combination.size(); ++i) {
            buffer.m_130070_(ForgeRegistries.ITEMS.getKey((Object)this.combination.get(i)).toString());
        }
    }

    public static Combination fromBuffer(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<Item> combination = new ArrayList<Item>(size);
        for (int i = 0; i < size; ++i) {
            combination.add(Combination.fromRegistryName(buffer.m_130277_()));
        }
        return new Combination(combination);
    }

    public String toString() {
        return "Combination:[" + String.join((CharSequence)",", this.combination.stream().map(item -> item.toString()).collect(Collectors.toList())) + "]";
    }

    private static Item fromRegistryName(String itemRegistryName) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemRegistryName));
        return item != null ? item : Items.f_41852_;
    }
}

