/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.lock_replacement;

import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.content.monobank.unlocking.Combination;
import io.github.mortuusars.monobank.core.inventory.CombinationContainer;
import io.github.mortuusars.monobank.core.inventory.GhostSlot;
import io.github.mortuusars.monobank.util.TextUtil;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LockReplacementMenu
extends AbstractContainerMenu {
    private final MonobankBlockEntity monobankEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    private final CombinationContainer combinationContainer;

    public LockReplacementMenu(int containerID, Inventory playerInventory, MonobankBlockEntity monobankEntity) {
        super((MenuType)Registry.MenuTypes.MONOBANK_LOCK_REPLACEMENT.get(), containerID);
        this.monobankEntity = monobankEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(monobankEntity.m_58904_()), (BlockPos)monobankEntity.m_58899_());
        this.combinationContainer = new CombinationContainer();
        this.m_38897_(new GhostSlot(this.combinationContainer, 0, 59, 35));
        this.m_38897_(new GhostSlot(this.combinationContainer, 1, 81, 35));
        this.m_38897_(new GhostSlot(this.combinationContainer, 2, 101, 35));
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, 8 + column * 18, 142));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
    }

    public static LockReplacementMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LockReplacementMenu(containerID, playerInventory, LockReplacementMenu.getBlockEntity(playerInventory, buffer));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot clickedSlot;
        if (index < 3) {
            ((Slot)this.f_38839_.get(index)).m_5852_(ItemStack.f_41583_);
        } else if (index < this.f_38839_.size() && (clickedSlot = (Slot)this.f_38839_.get(index)).m_6657_()) {
            ItemStack clickedItemStack = clickedSlot.m_7993_();
            for (int i = 0; i < 3; ++i) {
                Slot combinationSlot = (Slot)this.f_38839_.get(i);
                if (!combinationSlot.m_7993_().m_41619_()) continue;
                combinationSlot.m_5852_(new ItemStack((ItemLike)clickedItemStack.m_41720_()));
                break;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 3 || slotId < 0) {
            super.m_150399_(slotId, button, clickType, player);
            return;
        }
        Slot combinationSlot = (Slot)this.f_38839_.get(slotId);
        if (!this.m_142621_().m_41619_()) {
            combinationSlot.m_5852_(new ItemStack((ItemLike)this.m_142621_().m_41720_()));
        } else {
            combinationSlot.m_5852_(ItemStack.f_41583_);
        }
    }

    public boolean m_6366_(Player player, int buttonID) {
        ArrayList<Item> combination = new ArrayList<Item>(3);
        for (int i = 0; i < 3; ++i) {
            combination.add(((Slot)this.f_38839_.get(i)).m_7993_().m_41720_());
        }
        if (this.monobankEntity.replaceLock(player, new Combination(combination))) {
            player.m_5661_((Component)TextUtil.translate("message.lock_replaced", new Object[0]), true);
            ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
            if (itemInHand.m_150930_((Item)Registry.Items.REPLACEMENT_LOCK.get())) {
                itemInHand.m_41774_(1);
            } else {
                itemInHand = player.m_21120_(InteractionHand.OFF_HAND);
                if (itemInHand.m_150930_((Item)Registry.Items.REPLACEMENT_LOCK.get())) {
                    itemInHand.m_41774_(1);
                }
            }
            player.m_6915_();
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return !(this.monobankEntity.getOwner().isPlayerOwned() && !this.monobankEntity.getOwner().isOwnedBy(player) || !player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)Registry.Items.REPLACEMENT_LOCK.get()) && !player.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)Registry.Items.REPLACEMENT_LOCK.get()) || !LockReplacementMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)player, (Block)((Block)Registry.Blocks.MONOBANK.get())));
    }

    private static MonobankBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntityAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntityAtPos instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankBlockEntity = (MonobankBlockEntity)blockEntityAtPos;
            return monobankBlockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntityAtPos);
    }
}

