/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.component;

import net.minecraft.util.Mth;

public class DoorOpennessController {
    private final float step = 0.1f;
    private final float lockedStepModifier;
    private final float unlockedStepModifier;
    private final float openStepModifier;
    private final float closeStepModifier;
    private final float unlockedOpenness;
    private boolean locked;
    private boolean shouldBeOpen;
    private float openness;
    private float prevOpenness;

    public DoorOpennessController(float lockedStepModifier, float unlockedStepModifier, float openStepModifier, float closeStepModifier, float unlockedOpenness) {
        if (unlockedOpenness < 0.0f || unlockedOpenness > 1.0f) {
            throw new IllegalArgumentException("'unlockedOpenness' should be in range 0.0 - 1.0. Value: '" + unlockedOpenness + "'.");
        }
        this.lockedStepModifier = lockedStepModifier;
        this.unlockedStepModifier = unlockedStepModifier;
        this.openStepModifier = openStepModifier;
        this.closeStepModifier = closeStepModifier;
        this.unlockedOpenness = unlockedOpenness;
    }

    public void tickDoor() {
        this.prevOpenness = this.openness;
        if (this.locked && this.openness <= 0.0f) {
            return;
        }
        if (!this.locked && this.shouldBeOpen && this.openness >= 1.0f) {
            return;
        }
        if (this.locked && this.openness <= this.unlockedOpenness) {
            this.openness = Math.max(this.openness - 0.1f * this.lockedStepModifier, 0.0f);
        } else if (this.locked && this.openness > 0.0f) {
            this.openness = Math.max(this.openness - 0.1f * this.closeStepModifier, 0.0f);
        } else if (!this.locked && !this.shouldBeOpen) {
            this.openness = this.openness > this.unlockedOpenness ? Math.max(this.openness - 0.1f * this.closeStepModifier, this.unlockedOpenness) : Math.min(this.openness + 0.1f * this.unlockedStepModifier, this.unlockedOpenness);
        } else if (this.shouldBeOpen) {
            this.openness = Math.min(this.openness + 0.1f * this.openStepModifier, 1.0f);
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void shouldBeOpen(boolean shouldBeOpen) {
        this.shouldBeOpen = shouldBeOpen;
    }

    public float getOpenness(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevOpenness, (float)this.openness);
    }
}

