/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world.stealth;

import io.github.mortuusars.thief.world.stealth.modifier.DarknessModifier;
import io.github.mortuusars.thief.world.stealth.modifier.InvisibilityModifier;
import io.github.mortuusars.thief.world.stealth.modifier.SneakingModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class Stealth {
    private static final List<VisibilityModifier> visibilityModifiers = new ArrayList<VisibilityModifier>();

    public static List<VisibilityModifier> getVisibilityModifiers() {
        return visibilityModifiers;
    }

    public static void addModifier(VisibilityModifier modifier) {
        visibilityModifiers.add(modifier);
    }

    public static double getVisibility(LivingEntity criminal) {
        double value = 1.0;
        for (VisibilityModifier modifier : visibilityModifiers) {
            value = modifier.modify(criminal, value);
        }
        return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
    }

    static {
        Stealth.addModifier(new InvisibilityModifier());
        Stealth.addModifier(new SneakingModifier());
        Stealth.addModifier(new DarknessModifier());
    }

    public static interface VisibilityModifier {
        public double modify(LivingEntity var1, double var2);
    }
}

