/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.network.packet.serverbound;

import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.network.PacketDirection;
import io.github.mortuusars.thief.network.Packets;
import io.github.mortuusars.thief.network.packet.Packet;
import io.github.mortuusars.thief.network.packet.clientbound.VillagerGossipsS2CP;
import io.github.mortuusars.thief.network.packet.clientbound.VillagerReputationS2CP;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record QueryVillagerReputationC2SP(int villagerId, boolean withGossips) implements Packet
{
    public static final ResourceLocation ID = Thief.resource("query_villager_reputation");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.villagerId);
        buffer.writeBoolean(this.withGossips);
        return buffer;
    }

    public static QueryVillagerReputationC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new QueryVillagerReputationC2SP(buffer.m_130242_(), buffer.readBoolean());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        if (!(player instanceof ServerPlayer)) {
            Thief.LOGGER.error("Cannot handle {} packet: player is not ServerPlayer.", (Object)ID);
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        @Nullable Entity entity = serverPlayer.m_284548_().m_6815_(this.villagerId);
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            Packets.sendToClient(new VillagerReputationS2CP(entity.m_19879_(), villager.m_35532_(player)), serverPlayer);
            if (this.withGossips) {
                Packets.sendToClient(new VillagerGossipsS2CP(entity.m_19879_(), villager.m_35517_().m_26195_(player.m_20148_(), type -> type == GossipType.MAJOR_NEGATIVE), villager.m_35517_().m_26195_(player.m_20148_(), type -> type == GossipType.MINOR_NEGATIVE), villager.m_35517_().m_26195_(player.m_20148_(), type -> type == GossipType.MINOR_POSITIVE), villager.m_35517_().m_26195_(player.m_20148_(), type -> type == GossipType.MAJOR_POSITIVE), villager.m_35517_().m_26195_(player.m_20148_(), type -> type == GossipType.TRADING)), serverPlayer);
            }
        }
        return true;
    }
}

