/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.mixin.thief_reputation_events;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import io.github.mortuusars.thief.PlatformHelper;
import io.github.mortuusars.thief.world.Crime;
import io.github.mortuusars.thief.world.Reputation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    @Final
    private GossipContainer f_35377_;

    @Shadow
    public abstract GossipContainer m_35517_();

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onReputationEventFrom"}, at={@At(value="HEAD")})
    private void onReputationEventPre(ReputationEventType type, Entity target, CallbackInfo ci, @Share(value="reputationBefore") LocalIntRef reputationBefore) {
        reputationBefore.set(this.m_35517_().m_26195_(target.m_20148_(), gossip -> true));
        if (type instanceof Crime) {
            int minor;
            Crime crime = (Crime)type;
            int major = crime.getMajorNegativeChange();
            if (major > 0) {
                this.f_35377_.m_26191_(target.m_20148_(), GossipType.MAJOR_NEGATIVE, major);
            }
            if ((minor = crime.getMinorNegativeChange()) > 0) {
                this.f_35377_.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, minor);
            }
        }
    }

    @Inject(method={"onReputationEventFrom"}, at={@At(value="RETURN")})
    private void onReputationEventPost(ReputationEventType type, Entity target, CallbackInfo ci, @Share(value="reputationBefore") LocalIntRef reputationBefore) {
        Reputation after;
        Reputation before = Reputation.fromValue(reputationBefore.get());
        if (before != (after = Reputation.fromValue(this.m_35517_().m_26195_(target.m_20148_(), gossip -> true))) && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            PlatformHelper.fireReputationLevelChangedEvent(livingEntity, (Villager)this, before, after);
        }
    }
}

