/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.event;

import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.api.block_interaction.BlockInteraction;
import io.github.mortuusars.thief.world.Crime;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ServerEvents {
    public static void onBlockDestroyedByPlayer(ServerPlayer player, BlockPos pos, BlockState state) {
        if (!((Boolean)Config.Common.CRIME_FOR_BREAKING_PROTECTED_BLOCKS.get()).booleanValue()) {
            return;
        }
        Crime.fromBlockStateBreaking(player, pos, state).getCrime().ifPresent(crime -> crime.commit(player.m_284548_(), (LivingEntity)player, pos));
    }

    public static void onBlockInteract(ServerPlayer player, BlockPos pos, InteractionHand hand) {
        if (!((Boolean)Config.Common.CRIME_FOR_INTERACTING_WITH_PROTECTED_BLOCKS.get()).booleanValue()) {
            return;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return;
        }
        BlockState state = player.m_9236_().m_8055_(pos);
        if (BlockInteraction.handle(player, pos, state) != InteractionResult.PASS) {
            return;
        }
        Crime.fromBlockStateInteracting(player, pos, state).getCrime().ifPresent(crime -> crime.commit(player.m_284548_(), (LivingEntity)player, pos));
    }

    public static void onEntityKilled(ServerPlayer player, LivingEntity target, DamageSource damageSource) {
        if (!((Boolean)Config.Common.CRIME_FOR_KILLING_PROTECTED_ENTITIES.get()).booleanValue()) {
            return;
        }
        Crime.fromKilling(player, target).getCrime().ifPresent(crime -> crime.commit(player.m_284548_(), (LivingEntity)player, target.m_20183_()));
    }
}

