/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.compat.kubejs;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import io.github.mortuusars.thief.compat.kubejs.CrimeCommitedEventJS;
import io.github.mortuusars.thief.compat.kubejs.GiftGivenEventJS;
import io.github.mortuusars.thief.compat.kubejs.ReputationLevelChangedEventJS;
import io.github.mortuusars.thief.compat.kubejs.ThiefJSEvents;
import io.github.mortuusars.thief.compat.kubejs.forge.ThiefKubeJSPluginImpl;
import io.github.mortuusars.thief.world.Crime;
import io.github.mortuusars.thief.world.Reputation;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;

public class ThiefKubeJSPlugin
extends KubeJSPlugin {
    public void init() {
        ThiefKubeJSPlugin.subscribeToEvents();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void subscribeToEvents() {
        ThiefKubeJSPluginImpl.subscribeToEvents();
    }

    public void registerEvents() {
        ThiefJSEvents.register();
    }

    public static void fireCrimeCommitedEvent(LivingEntity criminal, Crime crime, List<LivingEntity> witnesses) {
        ThiefJSEvents.CRIME_COMMITED.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new CrimeCommitedEventJS(criminal, crime, witnesses));
    }

    public static void fireGiftGivenEvent(ServerPlayer player, Villager villager, ItemStack gift) {
        ThiefJSEvents.GIFT_GIVEN.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new GiftGivenEventJS(player, villager, gift));
    }

    public static void fireReputationLevelChangedEvent(LivingEntity criminal, Villager villager, Reputation oldReputation, Reputation newReputation) {
        ThiefJSEvents.REPUTATION_LEVEL_CHANGED.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new ReputationLevelChangedEventJS(criminal, villager, oldReputation, newReputation));
    }
}

