/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.advancement.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.world.Crime;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class CrimeCommitedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = Thief.resource("crime_commited");

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, @NotNull ContextAwarePredicate predicate, @NotNull DeserializationContext deserializationContext) {
        MinMaxBounds.Ints crime = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("crime"));
        EntityPredicate witness = EntityPredicate.m_36614_((JsonElement)json.get("witness"));
        return new TriggerInstance(predicate, crime, witness);
    }

    public void trigger(ServerPlayer player, Crime crime, List<LivingEntity> witnesses) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, crime, witnesses));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints crime;
        private final EntityPredicate witness;

        public TriggerInstance(ContextAwarePredicate predicate, MinMaxBounds.Ints crime, EntityPredicate witness) {
            super(ID, predicate);
            this.crime = crime;
            this.witness = witness;
        }

        public boolean matches(ServerPlayer player, Crime crime, List<LivingEntity> witnesses) {
            return this.crime.m_55327_() || this.crime.m_55390_(crime.ordinal()) && (this.witness.equals(EntityPredicate.f_36550_) || witnesses.stream().allMatch(w -> this.witness.m_36611_(player, (Entity)w)));
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            jsonobject.add("crime", this.crime.m_55328_());
            jsonobject.add("witness", this.witness.m_36606_());
            return jsonobject;
        }
    }
}

