/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.realmrpgquests.network;

import java.util.function.Supplier;
import net.mcreator.realmrpgquests.RealmrpgQuestsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RealmrpgQuestsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        RealmrpgQuestsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.questType = message.data.questType;
                    variables.questTarget = message.data.questTarget;
                    variables.questScore = message.data.questScore;
                    variables.questScoreNeeded = message.data.questScoreNeeded;
                    variables.questsCompleted = message.data.questsCompleted;
                    variables.hasActiveQuest = message.data.hasActiveQuest;
                    variables.questNpcUUID = message.data.questNpcUUID;
                    variables.questScoreEnough = message.data.questScoreEnough;
                    variables.questNpcName = message.data.questNpcName;
                    variables.checkForQuestItems = message.data.checkForQuestItems;
                    variables.questTracking = message.data.questTracking;
                    variables.questTargetSpecialName = message.data.questTargetSpecialName;
                    variables.npcX = message.data.npcX;
                    variables.npcZ = message.data.npcZ;
                    variables.itemCountTimer = message.data.itemCountTimer;
                    variables.isQuestSpecial = message.data.isQuestSpecial;
                    variables.questName = message.data.questName;
                    variables.questSpecialEvents = message.data.questSpecialEvents;
                    variables.markerFrame = message.data.markerFrame;
                    variables.markerTimer = message.data.markerTimer;
                    variables.npcDirection = message.data.npcDirection;
                    variables.questTaskSpecialName = message.data.questTaskSpecialName;
                    variables.bookOpenFrame = message.data.bookOpenFrame;
                    variables.bookOpenTimer = message.data.bookOpenTimer;
                    variables.questsCommonDone = message.data.questsCommonDone;
                    variables.questsRareDone = message.data.questsRareDone;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String questType = "\"\"";
        public String questTarget = "\"\"";
        public double questScore = 0.0;
        public double questScoreNeeded = 0.0;
        public double questsCompleted = 0.0;
        public boolean hasActiveQuest = false;
        public String questNpcUUID = "\"\"";
        public boolean questScoreEnough = false;
        public String questNpcName = "\"\"";
        public boolean checkForQuestItems = false;
        public double questTracking = 1.0;
        public String questTargetSpecialName = "\"\"";
        public double npcX = 0.0;
        public double npcZ = 0.0;
        public double itemCountTimer = 0.0;
        public double isQuestSpecial = 0.0;
        public String questName = "\"\"";
        public String questSpecialEvents = "\"\"";
        public double markerFrame = 0.0;
        public double markerTimer = 0.0;
        public double npcDirection = 0.0;
        public String questTaskSpecialName = "\"\"";
        public double bookOpenFrame = 0.0;
        public double bookOpenTimer = 0.0;
        public double questsCommonDone = 0.0;
        public double questsRareDone = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                RealmrpgQuestsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("questType", this.questType);
            nbt.m_128359_("questTarget", this.questTarget);
            nbt.m_128347_("questScore", this.questScore);
            nbt.m_128347_("questScoreNeeded", this.questScoreNeeded);
            nbt.m_128347_("questsCompleted", this.questsCompleted);
            nbt.m_128379_("hasActiveQuest", this.hasActiveQuest);
            nbt.m_128359_("questNpcUUID", this.questNpcUUID);
            nbt.m_128379_("questScoreEnough", this.questScoreEnough);
            nbt.m_128359_("questNpcName", this.questNpcName);
            nbt.m_128379_("checkForQuestItems", this.checkForQuestItems);
            nbt.m_128347_("questTracking", this.questTracking);
            nbt.m_128359_("questTargetSpecialName", this.questTargetSpecialName);
            nbt.m_128347_("npcX", this.npcX);
            nbt.m_128347_("npcZ", this.npcZ);
            nbt.m_128347_("itemCountTimer", this.itemCountTimer);
            nbt.m_128347_("isQuestSpecial", this.isQuestSpecial);
            nbt.m_128359_("questName", this.questName);
            nbt.m_128359_("questSpecialEvents", this.questSpecialEvents);
            nbt.m_128347_("markerFrame", this.markerFrame);
            nbt.m_128347_("markerTimer", this.markerTimer);
            nbt.m_128347_("npcDirection", this.npcDirection);
            nbt.m_128359_("questTaskSpecialName", this.questTaskSpecialName);
            nbt.m_128347_("bookOpenFrame", this.bookOpenFrame);
            nbt.m_128347_("bookOpenTimer", this.bookOpenTimer);
            nbt.m_128347_("questsCommonDone", this.questsCommonDone);
            nbt.m_128347_("questsRareDone", this.questsRareDone);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.questType = nbt.m_128461_("questType");
            this.questTarget = nbt.m_128461_("questTarget");
            this.questScore = nbt.m_128459_("questScore");
            this.questScoreNeeded = nbt.m_128459_("questScoreNeeded");
            this.questsCompleted = nbt.m_128459_("questsCompleted");
            this.hasActiveQuest = nbt.m_128471_("hasActiveQuest");
            this.questNpcUUID = nbt.m_128461_("questNpcUUID");
            this.questScoreEnough = nbt.m_128471_("questScoreEnough");
            this.questNpcName = nbt.m_128461_("questNpcName");
            this.checkForQuestItems = nbt.m_128471_("checkForQuestItems");
            this.questTracking = nbt.m_128459_("questTracking");
            this.questTargetSpecialName = nbt.m_128461_("questTargetSpecialName");
            this.npcX = nbt.m_128459_("npcX");
            this.npcZ = nbt.m_128459_("npcZ");
            this.itemCountTimer = nbt.m_128459_("itemCountTimer");
            this.isQuestSpecial = nbt.m_128459_("isQuestSpecial");
            this.questName = nbt.m_128461_("questName");
            this.questSpecialEvents = nbt.m_128461_("questSpecialEvents");
            this.markerFrame = nbt.m_128459_("markerFrame");
            this.markerTimer = nbt.m_128459_("markerTimer");
            this.npcDirection = nbt.m_128459_("npcDirection");
            this.questTaskSpecialName = nbt.m_128461_("questTaskSpecialName");
            this.bookOpenFrame = nbt.m_128459_("bookOpenFrame");
            this.bookOpenTimer = nbt.m_128459_("bookOpenTimer");
            this.questsCommonDone = nbt.m_128459_("questsCommonDone");
            this.questsRareDone = nbt.m_128459_("questsRareDone");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("realmrpg_quests", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.questType = original.questType;
            clone.questTarget = original.questTarget;
            clone.questScore = original.questScore;
            clone.questScoreNeeded = original.questScoreNeeded;
            clone.questsCompleted = original.questsCompleted;
            clone.hasActiveQuest = original.hasActiveQuest;
            clone.questNpcUUID = original.questNpcUUID;
            clone.questScoreEnough = original.questScoreEnough;
            clone.questNpcName = original.questNpcName;
            clone.checkForQuestItems = original.checkForQuestItems;
            clone.questTracking = original.questTracking;
            clone.questTargetSpecialName = original.questTargetSpecialName;
            clone.npcX = original.npcX;
            clone.npcZ = original.npcZ;
            clone.itemCountTimer = original.itemCountTimer;
            clone.isQuestSpecial = original.isQuestSpecial;
            clone.questName = original.questName;
            clone.questSpecialEvents = original.questSpecialEvents;
            clone.markerFrame = original.markerFrame;
            clone.markerTimer = original.markerTimer;
            clone.npcDirection = original.npcDirection;
            clone.questTaskSpecialName = original.questTaskSpecialName;
            clone.bookOpenFrame = original.bookOpenFrame;
            clone.bookOpenTimer = original.bookOpenTimer;
            clone.questsCommonDone = original.questsCommonDone;
            clone.questsRareDone = original.questsRareDone;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

