/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.formations.tools.FormationsLevelData;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import org.joml.Matrix4f;

public class StructureVoidHighlighter {
    private static final int HIGHLIGHT_RANGE = 15;
    private static final BlockShape HIGHLIGHT_SHAPE = BlockShape.fullCube().shrink(0.2);
    private static final RenderConfiguration QUADS = RenderConfiguration.create((String)"supermartijn642corelib", (String)"quads", (VertexFormat)DefaultVertexFormat.f_85815_, (RenderConfiguration.PrimitiveType)RenderConfiguration.PrimitiveType.QUADS, (int)256, (boolean)false, (boolean)true, (RenderStateConfiguration)RenderStateConfiguration.builder().useShader(GameRenderer::m_172811_).useTranslucentTransparency().disableTexture().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(StructureVoidHighlighter::highlightStructureVoidBlocks);
    }

    private static void highlightStructureVoidBlocks(RenderWorldEvent e) {
        if (!FormationsLevelData.CLIENT.isDevMode()) {
            return;
        }
        Player player = ClientUtils.getPlayer();
        Item mainItem = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        Item secondaryItem = player.m_21120_(InteractionHand.OFF_HAND).m_41720_();
        if (!(mainItem instanceof BlockItem && ((BlockItem)mainItem).m_40614_() instanceof StructureVoidBlock || secondaryItem instanceof BlockItem && ((BlockItem)secondaryItem).m_40614_() instanceof StructureVoidBlock)) {
            return;
        }
        e.getPoseStack().m_85836_();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        Level level = ClientUtils.getWorld();
        BlockPos center = player.m_20097_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        VertexConsumer builder = QUADS.begin((MultiBufferSource)bufferSource);
        for (int xOffset = -15; xOffset <= 15; ++xOffset) {
            for (int yOffset = -15; yOffset <= 15; ++yOffset) {
                for (int zOffset = -15; zOffset <= 15; ++zOffset) {
                    pos.m_122178_(center.m_123341_() + xOffset, center.m_123342_() + yOffset, center.m_123343_() + zOffset);
                    if (!(level.m_8055_((BlockPos)pos).m_60734_() instanceof StructureVoidBlock)) continue;
                    e.getPoseStack().m_85836_();
                    e.getPoseStack().m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    StructureVoidHighlighter.renderShapeSides(e.getPoseStack(), builder, HIGHLIGHT_SHAPE, 0.9607843f, 0.3647059f, 0.81960785f, 0.9f);
                    e.getPoseStack().m_85849_();
                }
            }
        }
        QUADS.end(bufferSource);
        e.getPoseStack().m_85849_();
    }

    public static void renderShapeSides(PoseStack poseStack, VertexConsumer builder, BlockShape shape, float red, float green, float blue, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        shape.forEachBox(box -> {
            float minX = (float)box.f_82288_;
            float maxX = (float)box.f_82291_;
            float minY = (float)box.f_82289_;
            float maxY = (float)box.f_82292_;
            float minZ = (float)box.f_82290_;
            float maxZ = (float)box.f_82293_;
            builder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        });
    }
}

