/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import com.supermartijn642.formations.structure.processors.EnchantmentHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class ChiseledBookshelfProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("slotFillChance", (Object)Float.valueOf(0.4f)).forGetter(p -> Float.valueOf(p.slotFillChance)), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("levels").forGetter(p -> p.minLevels != p.maxLevels || p.minLevels == 10 ? Optional.empty() : Optional.of(p.maxLevels)), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("min_levels").forGetter(p -> p.minLevels == p.maxLevels ? Optional.empty() : Optional.of(p.minLevels)), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("max_levels").forGetter(p -> p.minLevels == p.maxLevels ? Optional.empty() : Optional.of(p.maxLevels)), (App)Codec.BOOL.optionalFieldOf("allow_curses", (Object)true).forGetter(p -> p.allowCurses)).apply((Applicative)instance, (slotFillChance, levels, minLevels, maxLevels, allowCurses) -> {
        if (minLevels.isPresent() && maxLevels.isPresent()) {
            return new ChiseledBookshelfProcessor(slotFillChance.floatValue(), (Integer)minLevels.get(), (Integer)maxLevels.get(), (boolean)allowCurses);
        }
        int l = levels.orElse(10);
        return new ChiseledBookshelfProcessor(slotFillChance.floatValue(), l, l, (boolean)allowCurses);
    }));
    private final float slotFillChance;
    private final int minLevels;
    private final int maxLevels;
    private final boolean allowCurses;

    public ChiseledBookshelfProcessor(float slotFillChance, int minLevels, int maxLevels, boolean allowCurses) {
        this.slotFillChance = slotFillChance;
        this.minLevels = minLevels;
        this.maxLevels = maxLevels;
        this.allowCurses = allowCurses;
    }

    public ChiseledBookshelfProcessor(float slotFillChance) {
        this(slotFillChance, 10, 10, true);
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState state = block.state();
        if (state != null && state.m_60713_(Blocks.f_244299_)) {
            NonNullList books = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
            if (block.nbt() != null) {
                ContainerHelper.m_18980_((CompoundTag)block.nbt(), (NonNullList)books);
            }
            RandomSource random = placeSettings.m_230326_(pos);
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)books.get(i)).m_41619_() || !(random.m_188501_() < this.slotFillChance)) continue;
                int levels = random.m_188503_(this.maxLevels - this.minLevels + 1) + this.minLevels;
                ItemStack book = EnchantmentHelper.getRandomEnchantedBook(levels, true, this.allowCurses, true, random, level.m_246046_());
                books.set(i, (Object)book);
                state = (BlockState)state.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(i), (Comparable)Boolean.valueOf(true));
            }
            CompoundTag nbt = block.nbt() == null ? new CompoundTag() : block.nbt().m_6426_();
            ContainerHelper.m_18976_((CompoundTag)nbt, (NonNullList)books, (boolean)true);
            return new BlockInstance(state, nbt);
        }
        return block;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)FormationsStructures.CHISELED_BOOKSHELF_PROCESSOR.get();
    }
}

